/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraftforge.common.UsernameCache;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.internal.modintegration.ftblib.FTBLib_Base;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.network.PacketNameSync;

public class NameHelper {
    private static final Cache<String, String> NAMECACHE = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();
    private static Map<UUID, String> PLAYERS = Maps.newHashMap();
    private static Map<String, String> TEAMS = Maps.newHashMap();

    public static String getDisplayNameFor(String id) {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String name = uuid != null ? NameHelper.getLastKnownUsername(uuid) : NameHelper.getLastKnownTeamName(id);
        return !Strings.isNullOrEmpty((String)name) ? name : id;
    }

    public static String getLastKnownUsername(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid);
        if (UsernameCache.containsUUID((UUID)uuid)) {
            return Strings.nullToEmpty((String)UsernameCache.getLastKnownUsername((UUID)uuid));
        }
        String name = "";
        PlayerEntity player = ShetiPhianCore.PROXY.getClientPlayer();
        if (player != null && player.field_70170_p.field_72995_K) {
            name = (String)NAMECACHE.getIfPresent((Object)uuid.toString());
            if (!Strings.isNullOrEmpty((String)name)) {
                return name;
            }
            if (PLAYERS.containsKey(uuid)) {
                name = PLAYERS.get(uuid);
                NAMECACHE.put((Object)uuid.toString(), (Object)name);
            }
            NetworkHandler.sendToServer(new PacketNameSync(uuid, name));
        }
        return !Strings.isNullOrEmpty((String)name) ? name : uuid.toString();
    }

    public static String getLastKnownTeamName(String teamID) {
        Preconditions.checkNotNull((Object)teamID);
        String name = (String)NAMECACHE.getIfPresent((Object)teamID);
        if (!Strings.isNullOrEmpty((String)name)) {
            return name;
        }
        PlayerEntity player = ShetiPhianCore.PROXY.getClientPlayer();
        if (player != null && player.field_70170_p.field_72995_K) {
            if (TEAMS.containsKey(teamID)) {
                name = TEAMS.get(teamID);
            }
            NetworkHandler.sendToServer(new PacketNameSync(teamID, name));
        } else {
            Scoreboard scoreboard;
            name = FTBLib_Base.INSTANCE.getTeamName(teamID);
            if (Strings.isNullOrEmpty((String)name) && (scoreboard = ShetiPhianCore.PROXY.getScoreboard()) != null) {
                for (ScorePlayerTeam team : scoreboard.func_96525_g()) {
                    if (team == null || !team.func_96661_b().equalsIgnoreCase(teamID)) continue;
                    name = team.func_96669_c().toString();
                    break;
                }
            }
        }
        name = !Strings.isNullOrEmpty((String)name) ? name : "~" + teamID + "~";
        NAMECACHE.put((Object)teamID, (Object)name);
        return name;
    }

    public static void set(String id, String name) {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uuid != null) {
            if (!name.equals(PLAYERS.get(uuid))) {
                PLAYERS.put(uuid, name);
            }
        } else if (!name.equals(PLAYERS.get(uuid))) {
            TEAMS.put(id, name);
        }
        NAMECACHE.put((Object)id, (Object)name);
    }
}

