/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class ParticleHelper {
    private static Random random = new Random();

    public static boolean addLandingEffects(ServerWorld world, Entity entity, int numberOfParticles, BlockState particles) {
        world.func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, particles), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f);
        return true;
    }

    public static boolean addRunningEffects(World world, BlockPos pos, Entity entity, BlockState particles) {
        Vec3d vec3d = entity.func_213322_ci();
        EntitySize size = entity.func_213305_a(entity.func_213283_Z());
        world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, particles).setPos(pos), entity.func_226277_ct_() + ((double)random.nextFloat() - 0.5) * (double)size.field_220315_a, entity.func_226278_cu_() + 0.1, entity.func_226281_cx_() + ((double)random.nextFloat() - 0.5) * (double)size.field_220315_a, vec3d.field_72450_a * -4.0, 1.5, vec3d.field_72449_c * -4.0);
        return true;
    }

    public static boolean addHitEffects(BlockState state, World world, BlockPos pos, Direction side, ParticleManager manager, BlockState particles) {
        AtomicBoolean result = new AtomicBoolean(false);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> result.set(Client.addHitEffects(state, world, pos, side, manager, particles)));
        return result.get();
    }

    public static boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager, BlockState particles) {
        AtomicBoolean result = new AtomicBoolean(false);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> result.set(Client.addDestroyEffects(state, world, pos, manager, particles)));
        return result.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private Client() {
        }

        public static boolean addHitEffects(BlockState state, World world, BlockPos pos, Direction side, ParticleManager manager, BlockState particles) {
            if (state.func_185901_i() != BlockRenderType.INVISIBLE) {
                VoxelShape shape = state.func_196954_c((IBlockReader)world, pos);
                if (shape.func_197766_b()) {
                    return false;
                }
                int i = pos.func_177958_n();
                int j = pos.func_177956_o();
                int k = pos.func_177952_p();
                AxisAlignedBB axisalignedbb = shape.func_197752_a();
                double d0 = (double)i + random.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
                double d1 = (double)j + random.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
                double d2 = (double)k + random.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
                if (side == Direction.DOWN) {
                    d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
                }
                if (side == Direction.UP) {
                    d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
                }
                if (side == Direction.NORTH) {
                    d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
                }
                if (side == Direction.SOUTH) {
                    d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
                }
                if (side == Direction.WEST) {
                    d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
                }
                if (side == Direction.EAST) {
                    d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
                }
                manager.func_78873_a(new DiggingParticle(world, d0, d1, d2, 0.0, 0.0, 0.0, particles).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
                return true;
            }
            return false;
        }

        public static boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager, BlockState particles) {
            if (!state.isAir((IBlockReader)world, pos)) {
                VoxelShape voxelshape = state.func_196954_c((IBlockReader)world, pos);
                voxelshape.func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    double d1 = Math.min(1.0, maxX - minX);
                    double d2 = Math.min(1.0, maxY - minY);
                    double d3 = Math.min(1.0, maxZ - minZ);
                    int i = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.25)));
                    int j = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.25)));
                    int k = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.25)));
                    for (int l = 0; l < i; ++l) {
                        for (int i1 = 0; i1 < j; ++i1) {
                            for (int j1 = 0; j1 < k; ++j1) {
                                double d4 = ((double)l + 0.5) / (double)i;
                                double d5 = ((double)i1 + 0.5) / (double)j;
                                double d6 = ((double)j1 + 0.5) / (double)k;
                                double d7 = d4 * d1 + minX;
                                double d8 = d5 * d2 + minY;
                                double d9 = d6 * d3 + minZ;
                                manager.func_78873_a((Particle)new DiggingParticle(world, (double)pos.func_177958_n() + d7, (double)pos.func_177956_o() + d8, (double)pos.func_177952_p() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, particles).func_174846_a(pos));
                            }
                        }
                    }
                });
                return true;
            }
            return false;
        }
    }
}

