/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.network;

import com.google.common.base.Strings;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import shetiphian.core.common.NameHelper;
import shetiphian.core.common.network.PacketBase;
import shetiphian.core.internal.network.NetworkHandler;

public class PacketNameSync
extends PacketBase {
    private String id;
    private String name;

    public PacketNameSync(UUID uuid, String name) {
        this.id = uuid.toString();
        this.name = name;
    }

    public PacketNameSync(String teamID, String name) {
        this.id = teamID;
        this.name = name;
    }

    public static void writeData(PacketNameSync packet, PacketBuffer buffer) {
        PacketNameSync.writeString(buffer, packet.id);
        PacketNameSync.writeString(buffer, packet.name);
    }

    public static PacketNameSync readData(PacketBuffer buffer) {
        return new PacketNameSync(PacketNameSync.readString(buffer), PacketNameSync.readString(buffer));
    }

    @Override
    public void handleClientSide(PlayerEntity player) {
        if (!Strings.isNullOrEmpty((String)this.id) && !Strings.isNullOrEmpty((String)this.name)) {
            NameHelper.set(this.id, this.name);
        }
    }

    @Override
    public void handleServerSide(PlayerEntity player) {
        if (!Strings.isNullOrEmpty((String)this.id) && player instanceof ServerPlayerEntity) {
            String display = NameHelper.getDisplayNameFor(this.id);
            if (Strings.isNullOrEmpty((String)this.name) || !display.equalsIgnoreCase(this.name)) {
                NetworkHandler.sendToPlayer(new PacketNameSync(this.id, display), (ServerPlayerEntity)player);
            }
        }
    }
}

