/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.network;

import java.util.Random;
import joptsimple.internal.Strings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shetiphian.core.common.network.PacketBase;
import shetiphian.core.internal.network.NetworkHandler;

public class PacketParticle
extends PacketBase {
    private static PacketParticle INVALID = new PacketParticle(null, null, 0.0, 0.0, 0.0, 0.0, 0);
    private static Random random = new Random();
    private ParticleType particleType;
    private BlockPos sourcePos;
    private double xCoord;
    private double yCoord;
    private double zCoord;
    private double particleSpeed;
    private int particleCount;

    public PacketParticle(ParticleType particleType, BlockPos sourcePos, double xCoord, double yCoord, double zCoord, double particleSpeed, int particleCount) {
        this.particleType = particleType;
        this.sourcePos = sourcePos;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.particleSpeed = particleSpeed;
        this.particleCount = particleCount;
    }

    public static void writeData(PacketParticle packet, PacketBuffer buffer) {
        ResourceLocation particle = ForgeRegistries.PARTICLE_TYPES.getKey((IForgeRegistryEntry)packet.particleType);
        if (particle == null) {
            PacketParticle.writeString(buffer, "invalid");
            return;
        }
        PacketParticle.writeString(buffer, particle.toString());
        buffer.func_179255_a(packet.sourcePos);
        buffer.writeDouble(packet.xCoord);
        buffer.writeDouble(packet.yCoord);
        buffer.writeDouble(packet.zCoord);
        buffer.writeDouble(packet.particleSpeed);
        buffer.func_150787_b(packet.particleCount);
    }

    public static PacketParticle readData(PacketBuffer buffer) {
        String particle = PacketParticle.readString(buffer);
        if (Strings.isNullOrEmpty((String)particle) || particle.equals("invalid")) {
            return INVALID;
        }
        ParticleType particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(PacketParticle.readString(buffer)));
        return particleType == null ? INVALID : new PacketParticle(particleType, buffer.func_179259_c(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.func_150792_a());
    }

    @Override
    public void handleClientSide(PlayerEntity player) {
    }

    @Override
    public void handleServerSide(PlayerEntity player) {
        NetworkHandler.sendToPoint(this, player.field_71093_bK, this.sourcePos, 1024.0);
    }
}

