/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client;

import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiFunctions {
    public static GuiPass guiPass = new GuiPass();

    private static double[] getPixelScale(int ... imageSize) {
        int width;
        int n = width = imageSize.length >= 1 ? imageSize[0] : 256;
        int height = imageSize.length >= 2 ? imageSize[1] : (imageSize.length == 1 ? width : 256);
        return new double[]{1.0 / (double)width, 1.0 / (double)height};
    }

    public static void enterDrawTextureState() {
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void enterDrawTextureStateWithBlend() {
        GuiFunctions.enterDrawTextureState();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    public static void exitDrawTextureStateWithBlend() {
        GlStateManager.func_179084_k();
        GuiFunctions.exitDrawTextureState();
    }

    public static void exitDrawTextureState() {
        GlStateManager.func_179126_j();
    }

    public static void enterRenderItemState() {
        RenderHelper.func_74520_c();
    }

    public static void exitRenderItemState() {
    }

    public static void drawTexture(double posX, double posY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imageSize) {
        GuiFunctions.drawTextureScaled(posX, posY, posU, posV, sizeU, sizeV, 1.0, zLevel, imageSize);
    }

    public static void drawTextureScaled(double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale, float zLevel, int ... imageSize) {
        double[] pScale = GuiFunctions.getPixelScale(imageSize);
        double[] x = new double[]{posX, posX + (double)sizeU * scale};
        double[] y = new double[]{posY, posY + (double)sizeV * scale};
        double[] u = new double[]{(double)posU * pScale[0], (double)(posU + sizeU) * pScale[0]};
        double[] v = new double[]{(double)posV * pScale[1], (double)(posV + sizeV) * pScale[1]};
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(x[0], y[1], (double)zLevel).func_187315_a(u[0], v[1]).func_181675_d();
        renderer.func_181662_b(x[1], y[1], (double)zLevel).func_187315_a(u[1], v[1]).func_181675_d();
        renderer.func_181662_b(x[1], y[0], (double)zLevel).func_187315_a(u[1], v[0]).func_181675_d();
        renderer.func_181662_b(x[0], y[0], (double)zLevel).func_187315_a(u[0], v[0]).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTextureMirrored(int posX, int posY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imageSize) {
        GuiFunctions.drawTextureMirroredAndScaled(posX, posY, posU, posV, sizeU, sizeV, 1.0, zLevel, imageSize);
    }

    public static void drawTextureMirroredAndScaled(int posX, int posY, int posU, int posV, int sizeU, int sizeV, double scale, float zLevel, int ... imageSize) {
        double[] pScale = GuiFunctions.getPixelScale(imageSize);
        double[] x = new double[]{posX, (double)posX + (double)sizeU * scale};
        double[] y = new double[]{posY, (double)posY + (double)sizeV * scale};
        double[] u = new double[]{(double)posU * pScale[0], (double)(posU + sizeU) * pScale[0]};
        double[] v = new double[]{(double)posV * pScale[1], (double)(posV + sizeV) * pScale[1]};
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(x[0], y[1], (double)zLevel).func_187315_a(u[1], v[1]).func_181675_d();
        renderer.func_181662_b(x[1], y[1], (double)zLevel).func_187315_a(u[0], v[1]).func_181675_d();
        renderer.func_181662_b(x[1], y[0], (double)zLevel).func_187315_a(u[0], v[0]).func_181675_d();
        renderer.func_181662_b(x[0], y[0], (double)zLevel).func_187315_a(u[1], v[0]).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTextureInverted(int posX, int posY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imageSize) {
        GuiFunctions.drawTextureInvertedAndScaled(posX, posY, posU, posV, sizeU, sizeV, 1.0, zLevel, imageSize);
    }

    public static void drawTextureInvertedAndScaled(int posX, int posY, int posU, int posV, int sizeU, int sizeV, double scale, float zLevel, int ... imageSize) {
        double[] pScale = GuiFunctions.getPixelScale(imageSize);
        double[] x = new double[]{posX, (double)posX + (double)sizeU * scale};
        double[] y = new double[]{posY, (double)posY + (double)sizeV * scale};
        double[] u = new double[]{(double)posU * pScale[0], (double)(posU + sizeU) * pScale[0]};
        double[] v = new double[]{(double)posV * pScale[1], (double)(posV + sizeV) * pScale[1]};
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(x[0], y[1], (double)zLevel).func_187315_a(u[0], v[0]).func_181675_d();
        renderer.func_181662_b(x[1], y[1], (double)zLevel).func_187315_a(u[1], v[0]).func_181675_d();
        renderer.func_181662_b(x[1], y[0], (double)zLevel).func_187315_a(u[1], v[1]).func_181675_d();
        renderer.func_181662_b(x[0], y[0], (double)zLevel).func_187315_a(u[0], v[1]).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, float zLevel, int colorTopRight, int colorTopLeft, int colorBottomLeft, int colorBottomRight) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiFunctions.addColoredVertex(renderer, right, top, zLevel, colorTopRight);
        GuiFunctions.addColoredVertex(renderer, left, top, zLevel, colorTopLeft);
        GuiFunctions.addColoredVertex(renderer, left, bottom, zLevel, colorBottomLeft);
        GuiFunctions.addColoredVertex(renderer, right, bottom, zLevel, colorBottomRight);
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    private static void addColoredVertex(VertexBuffer renderer, int x, int y, float zLevel, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        renderer.func_181662_b((double)x, (double)y, (double)zLevel).func_181666_a(red, green, blue, alpha).func_181675_d();
    }

    public static void drawTexturedPane(double posX, double posY, double sizeX, double sizeY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imageSize) {
        double[] pScale = GuiFunctions.getPixelScale(imageSize);
        double[] x = new double[]{posX, posX + sizeX};
        double[] y = new double[]{posY, posY + sizeY};
        double[] u = new double[]{(double)posU * pScale[0], (double)(posU + sizeU) * pScale[0]};
        double[] v = new double[]{(double)posV * pScale[1], (double)(posV + sizeV) * pScale[1]};
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(x[0], y[1], (double)zLevel).func_187315_a(u[0], v[1]).func_181675_d();
        renderer.func_181662_b(x[1], y[1], (double)zLevel).func_187315_a(u[1], v[1]).func_181675_d();
        renderer.func_181662_b(x[1], y[0], (double)zLevel).func_187315_a(u[1], v[0]).func_181675_d();
        renderer.func_181662_b(x[0], y[0], (double)zLevel).func_187315_a(u[0], v[0]).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderToolTip(ItemStack stack, int x, int y, GuiScreen parent) {
        List list = stack.func_82840_a((EntityPlayer)parent.field_146297_k.field_71439_g, parent.field_146297_k.field_71474_y.field_82882_x);
        for (int line = 0; line < list.size(); ++line) {
            if (line == 0) {
                list.set(line, stack.func_77953_t().field_77937_e + (String)list.get(line));
                continue;
            }
            list.set(line, TextFormatting.GRAY + (String)list.get(line));
        }
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiFunctions.drawHoveringText(list, x, y, font == null ? parent.field_146297_k.field_71466_p : font, parent);
    }

    public static void drawHoveringText(List<String> list, int x, int y, FontRenderer fontRenderer, GuiScreen parent) {
        GuiUtils.drawHoveringText(list, (int)x, (int)y, (int)parent.field_146294_l, (int)parent.field_146295_m, (int)-1, (FontRenderer)fontRenderer);
    }

    public static void drawWrappedText(FontRenderer font, boolean unicode, String text, int left, int top, int right, int bottom, int color) {
        font.func_78264_a(unicode);
        List lines = font.func_78271_c(text, right - left);
        for (String line : lines) {
            guiPass.func_73731_b(font, line, left, top, color);
            if ((top += unicode ? 8 : 10) < bottom) continue;
            break;
        }
        font.func_78264_a(false);
    }

    public static class GuiPass
    extends GuiScreen {
        public void setZLevel(float zLevel) {
            this.field_73735_i = zLevel;
            if (this.field_146296_j != null) {
                this.field_146296_j.field_77023_b = zLevel;
            }
        }

        public void func_73733_a(int x1, int y1, int x2, int y2, int color1, int color2) {
            super.func_73733_a(x1, y1, x2, y2, color1, color2);
        }
    }
}

