/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.core.client.gui.ButtonIcon;
import shetiphian.core.client.gui.GuiScrollableTextBox;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.core.internal.NetworkHandler;
import shetiphian.core.internal.PacketSidedWrapper;

public abstract class GuiSidedContainer<SidedTile extends TileEntity>
extends GuiContainer {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("shetiphiancore", "textures/gui/info_config.png");
    private final SidedTile sidedTile;
    protected Mode mode = Mode.NORMAL;
    protected GuiScrollableTextBox infoBox;
    protected byte[] indexSide = new byte[]{-1, -1, -1, -1, -1, -1};
    protected String[] faceNames;
    protected String[] invNames;
    protected GuiButton hoveredButton;
    protected int hoverTime;
    private GuiButton buttonSave;

    public <T extends Container> GuiSidedContainer(T container, SidedTile sidedTile, boolean rotatable) {
        super(container);
        String[] stringArray;
        this.sidedTile = sidedTile;
        if (rotatable) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = "bottom";
            stringArray2[1] = "top";
            stringArray2[2] = "back";
            stringArray2[3] = "front";
            stringArray2[4] = "left";
            stringArray = stringArray2;
            stringArray2[5] = "right";
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = "down";
            stringArray3[1] = "up";
            stringArray3[2] = "north";
            stringArray3[3] = "south";
            stringArray3[4] = "west";
            stringArray = stringArray3;
            stringArray3[5] = "east";
        }
        this.faceNames = stringArray;
    }

    protected abstract List<String> getInfoBoxText();

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        switch (this.mode) {
            case NORMAL: {
                this.field_146292_n.add(new ButtonIcon(-1, this.field_147003_i - 18, this.field_147009_r + 16, 16, 16, GUI_TEXTURE, 224, 240, 224, 224, 224, 240));
                this.field_146292_n.add(new ButtonIcon(-2, this.field_147003_i - 18, this.field_147009_r + 40, 16, 16, GUI_TEXTURE, 240, 240, 240, 224, 240, 240));
                this.init();
                break;
            }
            case INFO: {
                this.field_146292_n.add(new ButtonIcon(-1, this.field_147003_i - 18, this.field_147009_r + 16, 16, 16, GUI_TEXTURE, 192, 240, 192, 224, 192, 240));
                this.field_146292_n.add(new ButtonIcon(-2, this.field_147003_i - 18, this.field_147009_r + 40, 16, 16, GUI_TEXTURE, 240, 240, 240, 224, 240, 240));
                this.infoBox = new GuiScrollableTextBox((GuiScreen)this, this.field_147003_i + 13, this.field_147009_r + this.field_147000_g - 84, 158, 72, this.getInfoBoxText(), true);
                break;
            }
            case CONFIG: {
                this.field_146292_n.add(new ButtonIcon(-1, this.field_147003_i - 18, this.field_147009_r + 16, 16, 16, GUI_TEXTURE, 192, 240, 192, 224, 192, 240));
                this.field_146292_n.add(new ButtonIcon(-2, this.field_147003_i - 18, this.field_147009_r + 40, 16, 16, GUI_TEXTURE, 224, 240, 224, 224, 224, 240));
                this.buttonSave = new ButtonIcon(-3, this.field_147003_i + 158, this.field_147009_r + this.field_147000_g - 88, 16, 16, GUI_TEXTURE, 208, 240, 208, 224, 208, 240);
                this.buttonSave.field_146125_m = false;
                this.field_146292_n.add(this.buttonSave);
                if (this.sidedTile != null) {
                    this.indexSide = (byte[])((ISidedWrapper)this.sidedTile).getSidedWrapper().getIndexes().clone();
                }
                int x = this.field_147003_i + 91;
                int y = this.field_147009_r + this.field_147000_g - 48;
                this.field_146292_n.add(new ButtonIcon(-4, x + 1, y - 11, 22, 22).setText(this.getFaceText(5)));
                this.field_146292_n.add(new ButtonIcon(-5, x - 47, y - 11, 22, 22).setText(this.getFaceText(4)));
                this.field_146292_n.add(new ButtonIcon(-6, x - 23, y - 11, 22, 22).setText(this.getFaceText(3)));
                this.field_146292_n.add(new ButtonIcon(-7, x + 25, y - 11, 22, 22).setText(this.getFaceText(2)));
                this.field_146292_n.add(new ButtonIcon(-8, x - 23, y - 35, 22, 22).setText(this.getFaceText(1)));
                this.field_146292_n.add(new ButtonIcon(-9, x - 23, y + 13, 22, 22).setText(this.getFaceText(0)));
            }
        }
    }

    private String getFaceText(int index) {
        String text = Localization.get("info." + this.faceNames[index]);
        return text.substring(0, 1).toUpperCase();
    }

    protected abstract void init();

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        super.func_146274_d();
        if (this.infoBox != null) {
            this.infoBox.handleMouseInput(mouseX, mouseY);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.mode == Mode.NORMAL) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        } else if (mouseButton == 0 || mouseButton == 1 || mouseButton == 2) {
            for (GuiButton button : this.field_146292_n) {
                if (button.field_146127_k >= 0 || !button.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                button.func_146113_a(this.field_146297_k.func_147118_V());
                this.func_146284_a(button);
                break;
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k > -1) {
            if (this.mode == Mode.NORMAL) {
                this.buttonClick(button);
            }
            return;
        }
        if (button.field_146127_k > -3) {
            if (button.field_146127_k == -1) {
                this.mode = this.mode == Mode.NORMAL ? Mode.INFO : Mode.NORMAL;
            } else if (button.field_146127_k == -2) {
                this.mode = this.mode == Mode.CONFIG ? Mode.INFO : Mode.CONFIG;
            }
            this.func_73866_w_();
            return;
        }
        if (this.mode != Mode.CONFIG || this.sidedTile == null) {
            return;
        }
        if (button.field_146127_k == -3) {
            NetworkHandler.sendToServer(new PacketSidedWrapper(this.sidedTile.func_174877_v(), this.indexSide));
            button.field_146125_m = false;
        } else if (button.field_146127_k < -3 && button.field_146127_k > -10) {
            byte max = (byte)(((ISidedWrapper)this.sidedTile).getSidedWrapper().getWrapperCount() - 1);
            int side = button.field_146127_k + 9;
            switch (Mouse.getEventButton()) {
                case 0: {
                    int n = side;
                    this.indexSide[n] = (byte)(this.indexSide[n] + 1);
                    if (this.indexSide[side] <= max) break;
                    this.indexSide[side] = -1;
                    break;
                }
                case 1: {
                    int n = side;
                    this.indexSide[n] = (byte)(this.indexSide[n] - 1);
                    if (this.indexSide[side] >= -1) break;
                    this.indexSide[side] = max;
                    break;
                }
                case 2: {
                    this.indexSide[side] = -1;
                }
            }
            if (this.buttonSave != null) {
                this.buttonSave.field_146125_m = false;
                byte[] original = ((ISidedWrapper)this.sidedTile).getSidedWrapper().getIndexes();
                for (int index = 0; index < 6; ++index) {
                    if (original[index] == this.indexSide[index]) continue;
                    this.buttonSave.field_146125_m = true;
                    break;
                }
            }
        }
    }

    protected abstract void buttonClick(GuiButton var1);

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.mode == Mode.NORMAL) {
            super.func_73863_a(mouseX, mouseY, partialTicks);
            return;
        }
        this.func_146276_q_();
        this.func_146976_a(partialTicks, mouseX, mouseY);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GuiButton lastButton = this.hoveredButton;
        this.hoveredButton = null;
        for (GuiButton button : this.field_146292_n) {
            button.func_146112_a(this.field_146297_k, mouseX, mouseY);
            if (!button.func_146115_a()) continue;
            if (lastButton != button) {
                this.hoverTime = 0;
            }
            this.hoveredButton = button;
        }
        this.hoverTime = this.hoveredButton == null ? 0 : MathHelper.func_76125_a((int)(this.hoverTime + 1), (int)0, (int)Integer.MAX_VALUE);
        for (GuiLabel label : this.field_146293_o) {
            label.func_146159_a(this.field_146297_k, mouseX, mouseY);
        }
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        this.func_146979_b(mouseX, mouseY);
        RenderHelper.func_74520_c();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.mode == Mode.NORMAL) {
            this.drawNormal(partialTicks, mouseX, mouseY);
            return;
        }
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.func_73729_b(this.field_147003_i, this.field_147009_r + this.field_147000_g - 98, 0, 158, 182, 98);
        if (this.mode == Mode.INFO) {
            this.func_73729_b(this.field_147003_i + 12, this.field_147009_r + this.field_147000_g - 85, 0, 84, 160, 74);
        } else {
            this.func_73729_b(this.buttonSave.field_146128_h, this.buttonSave.field_146129_i, 208, 208, this.buttonSave.field_146120_f, this.buttonSave.field_146121_g);
        }
        GuiFunctions.exitDrawTextureStateWithBlend();
        if (this.mode == Mode.INFO) {
            this.drawInfo(partialTicks, mouseX, mouseY);
        } else {
            this.drawConfig(partialTicks, mouseX, mouseY);
        }
    }

    protected abstract void drawNormal(float var1, int var2, int var3);

    protected abstract void drawInfo(float var1, int var2, int var3);

    protected abstract void drawConfig(float var1, int var2, int var3);

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.mode == Mode.CONFIG && this.hoveredButton != null && this.hoverTime >= 40 && this.hoveredButton.field_146127_k < -3) {
            byte index = this.indexSide[this.hoveredButton.field_146127_k + 9];
            ArrayList<String> list = new ArrayList<String>();
            list.add("\u00a7l" + Localization.get("info." + this.faceNames[this.hoveredButton.field_146127_k + 9]));
            if (this.invNames != null) {
                list.add("\u00a7o" + Localization.get(index > -1 && index < this.invNames.length ? this.invNames[index] : "gui.side_disabled.txt"));
            }
            this.func_146283_a(list, mouseX, mouseY);
        }
    }

    protected static enum Mode {
        NORMAL,
        INFO,
        CONFIG;

    }
}

