/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.ParticleBlockDust;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.ParticleHelper;
import shetiphian.core.common.network.PacketBase;
import shetiphian.core.common.network.PacketPipeline;
import shetiphian.core.internal.NetworkHandler;

public class PacketParticle
extends PacketBase {
    private static Random random = new Random();
    private EnumParticleTypes particleType;
    private BlockPos sourcePos;
    private double xCoord;
    private double yCoord;
    private double zCoord;
    private double xOffset;
    private double yOffset;
    private double zOffset;
    private double particleSpeed;
    private int particleCount;
    private int particleStateId;

    public PacketParticle() {
    }

    public PacketParticle(EnumParticleTypes particleType, BlockPos sourcePos, double xCoord, double yCoord, double zCoord, double xOffset, double yOffset, double zOffset, double particleSpeed, int particleCount, int particleStateId) {
        this.particleType = particleType;
        this.sourcePos = sourcePos;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        this.particleSpeed = particleSpeed;
        this.particleCount = particleCount;
        this.particleStateId = particleStateId;
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.writeInt(this.particleType.func_179348_c());
        buffer.func_179255_a(this.sourcePos);
        buffer.writeDouble(this.xCoord);
        buffer.writeDouble(this.yCoord);
        buffer.writeDouble(this.zCoord);
        buffer.writeDouble(this.xOffset);
        buffer.writeDouble(this.yOffset);
        buffer.writeDouble(this.zOffset);
        buffer.writeDouble(this.particleSpeed);
        buffer.writeInt(this.particleCount);
        buffer.writeInt(this.particleStateId);
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.particleType = EnumParticleTypes.func_179342_a((int)buffer.readInt());
        if (this.particleType == null) {
            this.particleType = EnumParticleTypes.BLOCK_CRACK;
        }
        this.sourcePos = buffer.func_179259_c();
        this.xCoord = buffer.readDouble();
        this.yCoord = buffer.readDouble();
        this.zCoord = buffer.readDouble();
        this.xOffset = buffer.readDouble();
        this.yOffset = buffer.readDouble();
        this.zOffset = buffer.readDouble();
        this.particleSpeed = buffer.readDouble();
        this.particleCount = buffer.readInt();
        this.particleStateId = buffer.readInt();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        ParticleManager effectRenderer = Minecraft.func_71410_x().field_71452_i;
        if (effectRenderer == null) {
            return;
        }
        ParticleDigging.Factory factory = null;
        switch (this.particleType) {
            case BLOCK_CRACK: {
                factory = new ParticleDigging.Factory();
                break;
            }
            case BLOCK_DUST: {
                factory = new ParticleBlockDust.Factory();
            }
        }
        if (factory == null) {
            return;
        }
        if (this.particleCount == 0) {
            double sX = this.particleSpeed * this.xCoord;
            double sY = this.particleSpeed * this.yCoord;
            double sZ = this.particleSpeed * this.zCoord;
            switch (this.particleType) {
                case BLOCK_CRACK: {
                    ParticleHelper.spawnDiggingFX(effectRenderer, (IParticleFactory)factory, player.func_130014_f_(), this.sourcePos, this.xCoord, this.yCoord, this.zCoord, sX, sY, sZ, this.particleStateId);
                    break;
                }
                case BLOCK_DUST: {
                    ParticleHelper.spawnBlockDustFX(effectRenderer, (IParticleFactory)factory, player.func_130014_f_(), this.sourcePos, this.xCoord, this.yCoord, this.zCoord, sX, sY, sZ, this.particleStateId);
                }
            }
        } else {
            block12: for (int counter = 0; counter < this.particleCount; ++counter) {
                double oX = random.nextGaussian() * this.xOffset;
                double oY = random.nextGaussian() * this.yOffset;
                double oZ = random.nextGaussian() * this.zOffset;
                double sX = random.nextGaussian() * this.particleSpeed;
                double sY = random.nextGaussian() * this.particleSpeed;
                double sZ = random.nextGaussian() * this.particleSpeed;
                switch (this.particleType) {
                    case BLOCK_CRACK: {
                        ParticleHelper.spawnDiggingFX(effectRenderer, (IParticleFactory)factory, player.func_130014_f_(), this.sourcePos, this.xCoord + oX, this.yCoord + oY, this.zCoord + oZ, sX, sY, sZ, this.particleStateId);
                        continue block12;
                    }
                    case BLOCK_DUST: {
                        ParticleHelper.spawnBlockDustFX(effectRenderer, (IParticleFactory)factory, player.func_130014_f_(), this.sourcePos, this.xCoord + oX, this.yCoord + oY, this.zCoord + oZ, sX, sY, sZ, this.particleStateId);
                    }
                }
            }
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        NetworkHandler.sendToPoint(this, new NetworkRegistry.TargetPoint(player.field_71093_bK, (double)this.sourcePos.func_177958_n(), (double)this.sourcePos.func_177956_o(), (double)this.sourcePos.func_177952_p(), 1024.0));
    }

    public static class Handler
    implements IMessageHandler<PacketParticle, IMessage> {
        public IMessage onMessage(PacketParticle packet, MessageContext ctx) {
            PacketPipeline.onMessage(packet, ctx);
            return null;
        }
    }
}

