/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.config.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiFunctions {
    public static GuiPass guiPass = new GuiPass((ITextComponent)new StringTextComponent("PassThroughGUI"));
    private static Tessellator tessellator = new Tessellator(0x200000);

    public static Tessellator getTessellator() {
        return tessellator;
    }

    private static double[] getPixelScale(int ... imageSize) {
        int width;
        int n = width = imageSize.length >= 1 ? imageSize[0] : 256;
        int height = imageSize.length >= 2 ? imageSize[1] : (imageSize.length == 1 ? width : 256);
        return new double[]{1.0 / (double)width, 1.0 / (double)height};
    }

    public static void enterDrawTextureState() {
        GlStateManager.disableDepthTest();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void enterDrawTextureStateWithBlend() {
        GuiFunctions.enterDrawTextureState();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
    }

    public static void exitDrawTextureStateWithBlend() {
        GlStateManager.disableBlend();
        GuiFunctions.exitDrawTextureState();
    }

    public static void exitDrawTextureState() {
        GlStateManager.enableDepthTest();
    }

    public static void enterRenderItemState() {
        RenderHelper.func_74520_c();
    }

    public static void exitRenderItemState() {
    }

    public static void drawTexture(double posX, double posY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imageSize) {
        GuiFunctions.drawTextureScaled(posX, posY, posU, posV, sizeU, sizeV, 1.0, zLevel, imageSize);
    }

    public static void drawTextureScaled(double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale, float zLevel, int ... imageSize) {
        double[] pScale = GuiFunctions.getPixelScale(imageSize);
        double[] x = new double[]{posX, posX + (double)sizeU * scale};
        double[] y = new double[]{posY, posY + (double)sizeV * scale};
        double[] u = new double[]{(double)posU * pScale[0], (double)(posU + sizeU) * pScale[0]};
        double[] v = new double[]{(double)posV * pScale[1], (double)(posV + sizeV) * pScale[1]};
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(x[0], y[1], (double)zLevel).func_187315_a(u[0], v[1]).func_181675_d();
        renderer.func_181662_b(x[1], y[1], (double)zLevel).func_187315_a(u[1], v[1]).func_181675_d();
        renderer.func_181662_b(x[1], y[0], (double)zLevel).func_187315_a(u[1], v[0]).func_181675_d();
        renderer.func_181662_b(x[0], y[0], (double)zLevel).func_187315_a(u[0], v[0]).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTextureMirrored(int posX, int posY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imageSize) {
        GuiFunctions.drawTextureMirroredAndScaled(posX, posY, posU, posV, sizeU, sizeV, 1.0, zLevel, imageSize);
    }

    public static void drawTextureMirroredAndScaled(int posX, int posY, int posU, int posV, int sizeU, int sizeV, double scale, float zLevel, int ... imageSize) {
        double[] pScale = GuiFunctions.getPixelScale(imageSize);
        double[] x = new double[]{posX, (double)posX + (double)sizeU * scale};
        double[] y = new double[]{posY, (double)posY + (double)sizeV * scale};
        double[] u = new double[]{(double)posU * pScale[0], (double)(posU + sizeU) * pScale[0]};
        double[] v = new double[]{(double)posV * pScale[1], (double)(posV + sizeV) * pScale[1]};
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(x[0], y[1], (double)zLevel).func_187315_a(u[1], v[1]).func_181675_d();
        renderer.func_181662_b(x[1], y[1], (double)zLevel).func_187315_a(u[0], v[1]).func_181675_d();
        renderer.func_181662_b(x[1], y[0], (double)zLevel).func_187315_a(u[0], v[0]).func_181675_d();
        renderer.func_181662_b(x[0], y[0], (double)zLevel).func_187315_a(u[1], v[0]).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTextureInverted(int posX, int posY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imageSize) {
        GuiFunctions.drawTextureInvertedAndScaled(posX, posY, posU, posV, sizeU, sizeV, 1.0, zLevel, imageSize);
    }

    public static void drawTextureInvertedAndScaled(int posX, int posY, int posU, int posV, int sizeU, int sizeV, double scale, float zLevel, int ... imageSize) {
        double[] pScale = GuiFunctions.getPixelScale(imageSize);
        double[] x = new double[]{posX, (double)posX + (double)sizeU * scale};
        double[] y = new double[]{posY, (double)posY + (double)sizeV * scale};
        double[] u = new double[]{(double)posU * pScale[0], (double)(posU + sizeU) * pScale[0]};
        double[] v = new double[]{(double)posV * pScale[1], (double)(posV + sizeV) * pScale[1]};
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(x[0], y[1], (double)zLevel).func_187315_a(u[0], v[0]).func_181675_d();
        renderer.func_181662_b(x[1], y[1], (double)zLevel).func_187315_a(u[1], v[0]).func_181675_d();
        renderer.func_181662_b(x[1], y[0], (double)zLevel).func_187315_a(u[1], v[1]).func_181675_d();
        renderer.func_181662_b(x[0], y[0], (double)zLevel).func_187315_a(u[0], v[1]).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawHorizontalGradient(double left, double top, double right, double bottom, float zLevel, int colorRight, int colorLeft) {
        GuiFunctions.drawGradientRect(left, top, right, bottom, zLevel, colorRight, colorLeft, colorLeft, colorRight);
    }

    public static void drawGradientRect(double left, double top, double right, double bottom, float zLevel, int colorTop, int colorBottom) {
        GuiFunctions.drawGradientRect(left, top, right, bottom, zLevel, colorTop, colorTop, colorBottom, colorBottom);
    }

    public static void drawRect(double left, double top, double right, double bottom, float zLevel, int color) {
        GuiFunctions.drawGradientRect(left, top, right, bottom, zLevel, color, color, color, color);
    }

    public static void drawGradientRect(double left, double top, double right, double bottom, float zLevel, int colorTopRight, int colorTopLeft, int colorBottomLeft, int colorBottomRight) {
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        GlStateManager.disableAlphaTest();
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GlStateManager.shadeModel((int)7425);
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiFunctions.addColoredVertex(renderer, right, top, zLevel, colorTopRight);
        GuiFunctions.addColoredVertex(renderer, left, top, zLevel, colorTopLeft);
        GuiFunctions.addColoredVertex(renderer, left, bottom, zLevel, colorBottomLeft);
        GuiFunctions.addColoredVertex(renderer, right, bottom, zLevel, colorBottomRight);
        tessellator.func_78381_a();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableTexture();
    }

    private static void addColoredVertex(BufferBuilder renderer, double x, double y, float zLevel, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        renderer.func_181662_b(x, y, (double)zLevel).func_181666_a(red, green, blue, alpha).func_181675_d();
    }

    public static void drawTexturedPane(double posX, double posY, double sizeX, double sizeY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imageSize) {
        double[] pScale = GuiFunctions.getPixelScale(imageSize);
        double[] x = new double[]{posX, posX + sizeX};
        double[] y = new double[]{posY, posY + sizeY};
        double[] u = new double[]{(double)posU * pScale[0], (double)(posU + sizeU) * pScale[0]};
        double[] v = new double[]{(double)posV * pScale[1], (double)(posV + sizeV) * pScale[1]};
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(x[0], y[1], (double)zLevel).func_187315_a(u[0], v[1]).func_181675_d();
        renderer.func_181662_b(x[1], y[1], (double)zLevel).func_187315_a(u[1], v[1]).func_181675_d();
        renderer.func_181662_b(x[1], y[0], (double)zLevel).func_187315_a(u[1], v[0]).func_181675_d();
        renderer.func_181662_b(x[0], y[0], (double)zLevel).func_187315_a(u[0], v[0]).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderToolTip(ItemStack stack, int x, int y, Screen parent) {
        List lines = stack.func_82840_a((PlayerEntity)parent.getMinecraft().field_71439_g, (ITooltipFlag)(parent.getMinecraft().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        ArrayList<String> list = new ArrayList<String>();
        for (ITextComponent line : lines) {
            list.add(line.func_150254_d());
        }
        for (int line = 0; line < list.size(); ++line) {
            if (line == 0) {
                list.set(line, stack.func_77953_t().field_77937_e + (String)list.get(line));
                continue;
            }
            list.set(line, TextFormatting.GRAY + (String)list.get(line));
        }
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiFunctions.drawHoveringText(list, x, y, font == null ? parent.getMinecraft().field_71466_p : font, parent);
    }

    public static void drawHoveringText(List<String> list, int x, int y, FontRenderer fontRenderer, Screen parent) {
        GuiUtils.drawHoveringText(list, (int)x, (int)y, (int)parent.width, (int)parent.height, (int)-1, (FontRenderer)fontRenderer);
    }

    public static void drawWrappedText(FontRenderer font, String text, int left, int top, int right, int bottom, int color) {
        List lines = font.func_78271_c(text, right - left);
        for (String line : lines) {
            guiPass.drawString(font, line, left, top, color);
            if ((top += 10) < bottom) continue;
            break;
        }
    }

    public static class GuiPass
    extends Screen {
        protected GuiPass(ITextComponent p_i51108_1_) {
            super(p_i51108_1_);
        }

        public void setZLevel(float zLevel) {
            if (this.itemRenderer != null) {
                this.itemRenderer.field_77023_b = zLevel;
            }
        }

        public void fillGradient(int x1, int y1, int x2, int y2, int color1, int color2) {
            super.fillGradient(x1, y1, x2, y2, color1, color2);
        }
    }
}

