/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public abstract class AbstractWidgetList<E extends AbstractList.AbstractListEntry<E>>
extends AbstractList<E> {
    private Pair<Integer, Integer> colorsFade = Pair.of((Object)-16777216, (Object)0);
    private Triple<Integer, Integer, Integer> colorsScrollBar = Triple.of((Object)-16777216, (Object)-4144960, (Object)-8355712);
    private Triple<Integer, Integer, Integer> colorsSelectionBox = Triple.of((Object)-16777216, (Object)-1, (Object)-8355712);

    public AbstractWidgetList(Minecraft mc, int x, int y, int width, int height, int entryHeight) {
        super(mc, width, height, y, y + height, entryHeight);
        this.setLeftPos(x);
    }

    public void updateSize(int width, int height, int top, int left) {
        this.width = width;
        this.height = height;
        this.y0 = top;
        this.y1 = top + height;
        this.x0 = left;
        this.x1 = left + width;
    }

    protected int getScrollbarPosition() {
        return this.x1;
    }

    public int getRowWidth() {
        return this.width;
    }

    private int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    protected void renderBackground(Tessellator tessellator, BufferBuilder bufferbuilder) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b((double)this.x0, (double)this.y1, 0.0).func_187315_a((double)((float)this.x0 / 32.0f), (double)((float)(this.y1 + (int)this.getScrollAmount()) / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
        bufferbuilder.func_181662_b((double)this.x1, (double)this.y1, 0.0).func_187315_a((double)((float)this.x1 / 32.0f), (double)((float)(this.y1 + (int)this.getScrollAmount()) / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
        bufferbuilder.func_181662_b((double)this.x1, (double)this.y0, 0.0).func_187315_a((double)((float)this.x1 / 32.0f), (double)((float)(this.y0 + (int)this.getScrollAmount()) / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
        bufferbuilder.func_181662_b((double)this.x0, (double)this.y0, 0.0).func_187315_a((double)((float)this.x0 / 32.0f), (double)((float)(this.y0 + (int)this.getScrollAmount()) / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    public void setFadeColors(int outer, int inner) {
        this.colorsFade = Pair.of((Object)outer, (Object)inner);
    }

    protected void renderFade(Tessellator tessellator, BufferBuilder bufferbuilder) {
        int[] outer = this.getARGB((Integer)this.colorsFade.getLeft());
        int[] inner = this.getARGB((Integer)this.colorsFade.getRight());
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b((double)this.x0, (double)(this.y0 + 4), 0.0).func_187315_a(0.0, 1.0).func_181669_b(inner[1], inner[2], inner[3], inner[0]).func_181675_d();
        bufferbuilder.func_181662_b((double)this.x1, (double)(this.y0 + 4), 0.0).func_187315_a(1.0, 1.0).func_181669_b(inner[1], inner[2], inner[3], inner[0]).func_181675_d();
        bufferbuilder.func_181662_b((double)this.x1, (double)this.y0, 0.0).func_187315_a(1.0, 0.0).func_181669_b(outer[1], outer[2], outer[3], outer[0]).func_181675_d();
        bufferbuilder.func_181662_b((double)this.x0, (double)this.y0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(outer[1], outer[2], outer[3], outer[0]).func_181675_d();
        tessellator.func_78381_a();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b((double)this.x0, (double)this.y1, 0.0).func_187315_a(0.0, 1.0).func_181669_b(outer[1], outer[2], outer[3], outer[0]).func_181675_d();
        bufferbuilder.func_181662_b((double)this.x1, (double)this.y1, 0.0).func_187315_a(1.0, 1.0).func_181669_b(outer[1], outer[2], outer[3], outer[0]).func_181675_d();
        bufferbuilder.func_181662_b((double)this.x1, (double)(this.y1 - 4), 0.0).func_187315_a(1.0, 0.0).func_181669_b(inner[1], inner[2], inner[3], inner[0]).func_181675_d();
        bufferbuilder.func_181662_b((double)this.x0, (double)(this.y1 - 4), 0.0).func_187315_a(0.0, 0.0).func_181669_b(inner[1], inner[2], inner[3], inner[0]).func_181675_d();
        tessellator.func_78381_a();
    }

    public void setScrollBarColors(int background, int slider, int shadow) {
        this.colorsScrollBar = Triple.of((Object)background, (Object)slider, (Object)shadow);
    }

    protected void renderScrollbar(Tessellator tessellator, BufferBuilder bufferbuilder) {
        int[] back = this.getARGB((Integer)this.colorsScrollBar.getLeft());
        int[] slider = this.getARGB((Integer)this.colorsScrollBar.getMiddle());
        int[] shadow = this.getARGB((Integer)this.colorsScrollBar.getRight());
        int i = this.getScrollbarPosition();
        int j = i + 6;
        int j1 = this.getMaxScroll();
        if (j1 > 0) {
            int k1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
            k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.y1 - this.y0 - 8));
            int l1 = (int)this.getScrollAmount() * (this.y1 - this.y0 - k1) / j1 + this.y0;
            if (l1 < this.y0) {
                l1 = this.y0;
            }
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_181662_b((double)i, (double)this.y1, 0.0).func_187315_a(0.0, 1.0).func_181669_b(back[1], back[2], back[3], back[0]).func_181675_d();
            bufferbuilder.func_181662_b((double)j, (double)this.y1, 0.0).func_187315_a(1.0, 1.0).func_181669_b(back[1], back[2], back[3], back[0]).func_181675_d();
            bufferbuilder.func_181662_b((double)j, (double)this.y0, 0.0).func_187315_a(1.0, 0.0).func_181669_b(back[1], back[2], back[3], back[0]).func_181675_d();
            bufferbuilder.func_181662_b((double)i, (double)this.y0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(back[1], back[2], back[3], back[0]).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_181662_b((double)i, (double)(l1 + k1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(shadow[1], shadow[2], shadow[3], shadow[0]).func_181675_d();
            bufferbuilder.func_181662_b((double)j, (double)(l1 + k1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(shadow[1], shadow[2], shadow[3], shadow[0]).func_181675_d();
            bufferbuilder.func_181662_b((double)j, (double)l1, 0.0).func_187315_a(1.0, 0.0).func_181669_b(shadow[1], shadow[2], shadow[3], shadow[0]).func_181675_d();
            bufferbuilder.func_181662_b((double)i, (double)l1, 0.0).func_187315_a(0.0, 0.0).func_181669_b(shadow[1], shadow[2], shadow[3], shadow[0]).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_181662_b((double)i, (double)(l1 + k1 - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(slider[1], slider[2], slider[3], slider[0]).func_181675_d();
            bufferbuilder.func_181662_b((double)(j - 1), (double)(l1 + k1 - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(slider[1], slider[2], slider[3], slider[0]).func_181675_d();
            bufferbuilder.func_181662_b((double)(j - 1), (double)l1, 0.0).func_187315_a(1.0, 0.0).func_181669_b(slider[1], slider[2], slider[3], slider[0]).func_181675_d();
            bufferbuilder.func_181662_b((double)i, (double)l1, 0.0).func_187315_a(0.0, 0.0).func_181669_b(slider[1], slider[2], slider[3], slider[0]).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        GlStateManager.disableLighting();
        GlStateManager.disableFog();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(AbstractGui.BACKGROUND_LOCATION);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderBackground(tessellator, bufferbuilder);
        int rowLeft = this.getRowLeft();
        int l = this.y0 + 4 - (int)this.getScrollAmount();
        if (this.renderHeader) {
            this.renderHeader(rowLeft, l, tessellator);
        }
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        this.renderList(rowLeft, l, mouseX, mouseY, partialTicks);
        GlStateManager.disableBlend();
        GlStateManager.disableDepthTest();
        this.renderHoleBackground(0, this.y0, 255, 255);
        this.renderHoleBackground(this.y1, this.height, 255, 255);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.disableAlphaTest();
        GlStateManager.shadeModel((int)7425);
        GlStateManager.disableTexture();
        this.renderFade(tessellator, bufferbuilder);
        this.renderScrollbar(tessellator, bufferbuilder);
        this.renderDecorations(mouseX, mouseY);
        GlStateManager.enableTexture();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.enableAlphaTest();
        GlStateManager.disableBlend();
    }

    private int getRowBottom(int p_getRowBottom_1_) {
        return this.getRowTop(p_getRowBottom_1_) + this.itemHeight;
    }

    public void setSelectionBoxColors(int background, int border_focused, int border_unfocused) {
        this.colorsSelectionBox = Triple.of((Object)background, (Object)border_focused, (Object)border_unfocused);
    }

    protected void renderSelectionBox(Tessellator tessellator, BufferBuilder bufferbuilder, int i1, int itemHeight, int rowWidth) {
        int[] back = this.getARGB((Integer)this.colorsSelectionBox.getLeft());
        int[] border = this.getARGB(this.isFocused() ? ((Integer)this.colorsSelectionBox.getMiddle()).intValue() : ((Integer)this.colorsSelectionBox.getRight()).intValue());
        int l1 = this.x0 + 1 + this.width / 2 - rowWidth / 2;
        int i2 = this.x0 + this.width / 2 + rowWidth / 2;
        GlStateManager.disableTexture();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)l1, (double)(i1 + itemHeight + 2), 0.0).func_181669_b(border[1], border[2], border[3], border[0]).func_181675_d();
        bufferbuilder.func_181662_b((double)i2, (double)(i1 + itemHeight + 2), 0.0).func_181669_b(border[1], border[2], border[3], border[0]).func_181675_d();
        bufferbuilder.func_181662_b((double)i2, (double)(i1 - 2), 0.0).func_181669_b(border[1], border[2], border[3], border[0]).func_181675_d();
        bufferbuilder.func_181662_b((double)l1, (double)(i1 - 2), 0.0).func_181669_b(border[1], border[2], border[3], border[0]).func_181675_d();
        tessellator.func_78381_a();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)(l1 + 1), (double)(i1 + itemHeight + 1), 0.0).func_181669_b(back[1], back[2], back[3], back[0]).func_181675_d();
        bufferbuilder.func_181662_b((double)(i2 - 1), (double)(i1 + itemHeight + 1), 0.0).func_181669_b(back[1], back[2], back[3], back[0]).func_181675_d();
        bufferbuilder.func_181662_b((double)(i2 - 1), (double)(i1 - 1), 0.0).func_181669_b(back[1], back[2], back[3], back[0]).func_181675_d();
        bufferbuilder.func_181662_b((double)(l1 + 1), (double)(i1 - 1), 0.0).func_181669_b(back[1], back[2], back[3], back[0]).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableTexture();
    }

    protected void renderList(int rowLeft, int p_renderList_2_, int mouseX, int mouseY, float partialTicks) {
        int i = this.getItemCount();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (int index = 0; index < i; ++index) {
            int rowTop = this.getRowTop(index);
            int l = this.getRowBottom(index);
            if (l < this.y0 || rowTop > this.y1) continue;
            int i1 = p_renderList_2_ + index * this.itemHeight + this.headerHeight;
            int itemHeight = this.itemHeight - 4;
            AbstractList.AbstractListEntry e = this.getEntry(index);
            int rowWidth = this.getRowWidth();
            if (this.renderSelection && this.isSelectedItem(index)) {
                this.renderSelectionBox(tessellator, bufferbuilder, i1, itemHeight, rowWidth);
            }
            e.render(index, rowTop, rowLeft, rowWidth, itemHeight, mouseX, mouseY, this.isMouseOver(mouseX, mouseY) && Objects.equals(this.getEntryAtPosition(mouseX, mouseY), e), partialTicks);
        }
    }

    private int[] getARGB(int javaColor) {
        return new int[]{(javaColor & 0xFF000000) >> 24, (javaColor & 0xFF0000) >> 16, (javaColor & 0xFF00) >> 8, javaColor & 0xFF};
    }
}

