/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import com.google.common.base.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import shetiphian.core.client.GuiFunctions;

public abstract class ButtonIcon
extends Button {
    private ResourceLocation texture;
    private final int[] normal;
    private final int[] hover;
    private final int[] pressed;
    protected String displayString;
    private Button.IPressable iPressable;

    public ButtonIcon(int posX, int posY, int sizeX, int sizeY) {
        this(posX, posY, sizeX, sizeY, null, 0, 0, 0, 0, 0, 0);
    }

    public ButtonIcon(int posX, int posY, int sizeX, int sizeY, ResourceLocation texture, int nU, int nV, int hU, int hV, int pU, int pV) {
        this(posX, posY, sizeX, sizeY, texture, new int[]{nU, nV}, new int[]{hU, hV}, new int[]{pU, pV});
    }

    public ButtonIcon(int posX, int posY, int sizeX, int sizeY, ResourceLocation texture, int[] normal, int[] hover, int[] pressed) {
        super(posX, posY, sizeX, sizeY, "", null);
        this.texture = texture;
        this.normal = normal;
        this.hover = hover;
        this.pressed = pressed;
    }

    public ButtonIcon setText(String text) {
        this.displayString = text;
        return this;
    }

    public ButtonIcon setPress(Button.IPressable iPressable) {
        this.iPressable = iPressable;
        return this;
    }

    public void onPress() {
        if (this.iPressable != null) {
            this.iPressable.onPress((Button)this);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (!this.visible) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        boolean bl = this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        if (this.texture != null) {
            mc.func_110434_K().func_110577_a(this.texture);
            GuiFunctions.enterDrawTextureStateWithBlend();
            if (this.isHovered && mc.field_71417_B.func_198030_b()) {
                this.blit(this.x, this.y, this.pressed[0], this.pressed[1], this.width, this.height);
            } else if (this.isHovered) {
                this.blit(this.x, this.y, this.hover[0], this.hover[1], this.width, this.height);
            } else {
                this.blit(this.x, this.y, this.normal[0], this.normal[1], this.width, this.height);
            }
            GuiFunctions.exitDrawTextureStateWithBlend();
        }
        if (!Strings.isNullOrEmpty((String)this.displayString)) {
            this.drawCenteredString(mc.field_71466_p, this.displayString, this.x + this.width / 2, this.y + (this.height - 8) / 2, -1);
        }
    }
}

