/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.core.client.gui.ButtonIcon;
import shetiphian.core.client.gui.WidgetInfoBox;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.core.common.inventory.SidedContainer;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.network.PacketSidedWrapper;

@OnlyIn(value=Dist.CLIENT)
public abstract class GuiSidedContainer<T extends SidedContainer<?>>
extends ContainerScreen<T> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("shetiphiancore", "textures/gui/info_config.png");
    protected Mode mode = Mode.NORMAL;
    protected WidgetInfoBox infoBox;
    protected byte[] indexSide = new byte[]{-1, -1, -1, -1, -1, -1};
    protected String[] faceNames;
    protected String[] invNames;
    protected Button hoveredButton;
    protected int hoverTime;
    private Button buttonSave;

    public GuiSidedContainer(T container, boolean rotatable, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, title);
        String[] stringArray;
        if (rotatable) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = "bottom";
            stringArray2[1] = "top";
            stringArray2[2] = "back";
            stringArray2[3] = "front";
            stringArray2[4] = "left";
            stringArray = stringArray2;
            stringArray2[5] = "right";
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = "down";
            stringArray3[1] = "up";
            stringArray3[2] = "north";
            stringArray3[3] = "south";
            stringArray3[4] = "west";
            stringArray = stringArray3;
            stringArray3[5] = "east";
        }
        this.faceNames = stringArray;
    }

    protected abstract List<String> getInfoBoxText();

    public void init() {
        super.init();
        this.buttons.clear();
        this.children.clear();
        switch (this.mode) {
            case NORMAL: {
                this.buttons.add(new ButtonMode(this.field_147003_i - 18, this.field_147009_r + 16, Mode.INFO));
                this.buttons.add(new ButtonMode(this.field_147003_i - 18, this.field_147009_r + 40, Mode.CONFIG));
                this.initSidedContainer();
                break;
            }
            case INFO: {
                this.buttons.add(new ButtonMode(this.field_147003_i - 18, this.field_147009_r + 16, Mode.NORMAL));
                this.buttons.add(new ButtonMode(this.field_147003_i - 18, this.field_147009_r + 40, Mode.CONFIG));
                this.infoBox = new WidgetInfoBox(this.minecraft, this.field_147003_i + 13, this.field_147009_r + this.field_147000_g - 84, 158, 72).addHeader(this.getInfoBoxText());
                break;
            }
            case CONFIG: {
                this.buttons.add(new ButtonMode(this.field_147003_i - 18, this.field_147009_r + 16, Mode.NORMAL));
                this.buttons.add(new ButtonMode(this.field_147003_i - 18, this.field_147009_r + 40, Mode.INFO));
                this.buttonSave = new ButtonSave(this.field_147003_i + 158, this.field_147009_r + this.field_147000_g - 88);
                this.buttons.add(this.buttonSave);
                if (((SidedContainer)this.field_147002_h).getTile() != null) {
                    this.indexSide = (byte[])((SidedContainer)this.field_147002_h).getSidedWrapper().getIndexes().clone();
                }
                int x = this.field_147003_i + 91;
                int y = this.field_147009_r + this.field_147000_g - 48;
                this.buttons.add(new ButtonFace(x + 1, y - 11, 22, 22, Direction.EAST));
                this.buttons.add(new ButtonFace(x - 47, y - 11, 22, 22, Direction.WEST));
                this.buttons.add(new ButtonFace(x - 23, y - 11, 22, 22, Direction.SOUTH));
                this.buttons.add(new ButtonFace(x + 25, y - 11, 22, 22, Direction.NORTH));
                this.buttons.add(new ButtonFace(x - 23, y - 35, 22, 22, Direction.UP));
                this.buttons.add(new ButtonFace(x - 23, y + 13, 22, 22, Direction.DOWN));
            }
        }
    }

    private String getFaceText(int index) {
        String text = Localization.get("info." + this.faceNames[index]);
        return text.substring(0, 1).toUpperCase();
    }

    protected abstract void initSidedContainer();

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        if (this.mode == Mode.NORMAL) {
            super.render(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
            return;
        }
        this.func_146976_a(partialTicks, mouseX, mouseY);
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawBackground((ContainerScreen)this, mouseX, mouseY));
        GlStateManager.disableRescaleNormal();
        RenderHelper.func_74518_a();
        GlStateManager.disableLighting();
        GlStateManager.disableDepthTest();
        Button lastButton = this.hoveredButton;
        this.hoveredButton = null;
        for (Widget widget : this.buttons) {
            widget.render(mouseX, mouseY, partialTicks);
            if (!(widget instanceof Button) || !widget.isMouseOver((double)mouseX, (double)mouseY)) continue;
            if (lastButton != widget) {
                this.hoverTime = 0;
            }
            this.hoveredButton = (Button)widget;
        }
        this.hoverTime = this.hoveredButton == null ? 0 : MathHelper.func_76125_a((int)(this.hoverTime + 1), (int)0, (int)Integer.MAX_VALUE);
        RenderHelper.func_74520_c();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableRescaleNormal();
        RenderHelper.func_74518_a();
        this.func_146979_b(mouseX, mouseY);
        RenderHelper.func_74520_c();
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawForeground((ContainerScreen)this, mouseX, mouseY));
        GlStateManager.popMatrix();
        GlStateManager.enableLighting();
        GlStateManager.enableDepthTest();
        RenderHelper.func_74519_b();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.mode == Mode.NORMAL) {
            this.drawNormal(partialTicks, mouseX, mouseY);
            return;
        }
        this.minecraft.func_110434_K().func_110577_a(GUI_TEXTURE);
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.blit(this.field_147003_i, this.field_147009_r + this.field_147000_g - 98, 0, 158, 182, 98);
        if (this.mode == Mode.INFO) {
            this.blit(this.field_147003_i + 12, this.field_147009_r + this.field_147000_g - 85, 0, 84, 160, 74);
        } else {
            this.blit(this.buttonSave.x, this.buttonSave.y, 208, 208, this.buttonSave.getWidth(), this.buttonSave.getHeight());
        }
        GuiFunctions.exitDrawTextureStateWithBlend();
        if (this.mode == Mode.INFO) {
            this.drawInfo(partialTicks, mouseX, mouseY);
            this.minecraft.func_110434_K().func_110577_a(GUI_TEXTURE);
            this.blit(this.field_147003_i + 12, this.field_147009_r + this.field_147000_g - 92, 12, 164, 160, 8);
            this.blit(this.field_147003_i + 12, this.field_147009_r + this.field_147000_g - 85, 0, 84, 160, 1);
            this.blit(this.field_147003_i + 12, this.field_147009_r + this.field_147000_g - 12, 0, 157, 160, 1);
            this.blit(this.field_147003_i + 12, this.field_147009_r + this.field_147000_g - 11, 12, 245, 160, 8);
        } else {
            this.drawConfig(partialTicks, mouseX, mouseY);
        }
    }

    protected abstract void drawNormal(float var1, int var2, int var3);

    protected abstract void drawInfo(float var1, int var2, int var3);

    protected abstract void drawConfig(float var1, int var2, int var3);

    protected void renderFaceButton(Widget button, Direction face, int mouseX, int mouseY, float partialTicks) {
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.mode == Mode.CONFIG && this.hoverTime >= 40 && this.hoveredButton instanceof ButtonFace) {
            int id = ((ButtonFace)this.hoveredButton).faceIndex;
            byte index = this.indexSide[id];
            ArrayList<String> list = new ArrayList<String>();
            list.add("\u00a7l" + Localization.get("info." + this.faceNames[id]));
            if (this.invNames != null) {
                list.add("\u00a7o" + Localization.get(index > -1 && index < this.invNames.length ? this.invNames[index] : "gui.side_disabled.txt"));
            }
            this.renderTooltip(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.mode == Mode.INFO && this.infoBox.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (this.mode == Mode.INFO && this.infoBox.func_223281_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char character, int value) {
        if (this.mode == Mode.INFO && this.infoBox.charTyped(character, value)) {
            return true;
        }
        return super.charTyped(character, value);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.mode == Mode.INFO && this.infoBox.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double accelX, double accelY) {
        if (this.mode == Mode.INFO && this.infoBox.mouseDragged(mouseX, mouseY, button, accelX, accelY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, accelX, accelY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (this.mode == Mode.INFO && this.infoBox.mouseScrolled(mouseX, mouseY, scroll)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scroll);
    }

    private class ButtonFace
    extends ButtonIcon {
        private final GuiSidedContainer<T> parent;
        private final Direction face;
        private final int faceIndex;

        ButtonFace(int posX, int posY, int sizeX, int sizeY, Direction face) {
            super(posX, posY, sizeX, sizeY);
            this.parent = GuiSidedContainer.this;
            this.parent.children.add(this);
            this.face = face;
            this.faceIndex = face.func_176745_a();
            this.setText(this.parent.getFaceText(this.faceIndex));
        }

        @Override
        public void render(int mouseX, int mouseY, float partialTicks) {
            if (!this.visible) {
                return;
            }
            this.parent.renderFaceButton((Widget)this, this.face, mouseX, mouseY, partialTicks);
            if (!Strings.isNullOrEmpty((String)this.displayString)) {
                this.drawCenteredString(this.parent.font, this.displayString, this.x + this.width / 2, this.y + (this.height - 8) / 2, -1);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.clicked(mouseX, mouseY)) {
                this.playDownSound(Minecraft.func_71410_x().func_147118_V());
                ISidedWrapper.SidedWrapper wrapper = ((ISidedWrapper)((SidedContainer)this.parent.field_147002_h).getTile()).getSidedWrapper();
                byte max = (byte)(wrapper.getWrapperCount() - 1);
                switch (button) {
                    case 0: {
                        int n = this.faceIndex;
                        this.parent.indexSide[n] = (byte)(this.parent.indexSide[n] + 1);
                        if (this.parent.indexSide[this.faceIndex] <= max) break;
                        this.parent.indexSide[this.faceIndex] = -1;
                        break;
                    }
                    case 1: {
                        int n = this.faceIndex;
                        this.parent.indexSide[n] = (byte)(this.parent.indexSide[n] - 1);
                        if (this.parent.indexSide[this.faceIndex] >= -1) break;
                        this.parent.indexSide[this.faceIndex] = max;
                        break;
                    }
                    case 2: {
                        this.parent.indexSide[this.faceIndex] = -1;
                    }
                }
                if (this.parent.buttonSave != null) {
                    ((GuiSidedContainer)this.parent).buttonSave.visible = false;
                    byte[] original = wrapper.getIndexes();
                    for (int index = 0; index < 6; ++index) {
                        if (original[index] == this.parent.indexSide[index]) continue;
                        ((GuiSidedContainer)this.parent).buttonSave.visible = true;
                        break;
                    }
                }
                return true;
            }
            return false;
        }
    }

    private class ButtonSave
    extends ButtonIcon {
        private final GuiSidedContainer<T> parent;

        ButtonSave(int posX, int posY) {
            super(posX, posY, 16, 16, GUI_TEXTURE, 208, 240, 208, 224, 208, 240);
            this.parent = GuiSidedContainer.this;
            this.parent.children.add(this);
            this.visible = false;
        }

        @Override
        public void onPress() {
            NetworkHandler.sendToServer(new PacketSidedWrapper(((SidedContainer)this.parent.field_147002_h).getTile().func_174877_v(), this.parent.indexSide));
            this.visible = false;
        }
    }

    private class ButtonMode
    extends ButtonIcon {
        private final GuiSidedContainer<T> parent;
        private final Mode mode;

        ButtonMode(int posX, int posY, Mode mode) {
            super(posX, posY, 16, 16, GUI_TEXTURE, mode.normal, mode.hover, mode.pressed);
            this.parent = GuiSidedContainer.this;
            this.parent.children.add(this);
            this.mode = mode;
        }

        @Override
        public void onPress() {
            this.parent.mode = this.mode;
            this.parent.init();
        }
    }

    protected static enum Mode {
        NORMAL(192, 240, 192, 224, 192, 240),
        INFO(224, 240, 224, 224, 224, 240),
        CONFIG(240, 240, 240, 224, 240, 240);

        private final int[] normal;
        private final int[] hover;
        private final int[] pressed;

        private Mode(int nU, int nV, int hU, int hV, int pU, int pV) {
            this.normal = new int[]{nU, nV};
            this.hover = new int[]{hU, hV};
            this.pressed = new int[]{pU, pV};
        }
    }
}

