/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.RenderComponentsUtil;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeHooks;
import shetiphian.core.client.gui.AbstractWidgetList;

public class WidgetInfoBox
extends AbstractWidgetList<Entry> {
    private List<ITextComponent> lines;
    private FontRenderer fontRenderer;

    public WidgetInfoBox(Minecraft mc, int x, int y, int width, int height) {
        super(mc, x, y, width, height, 10);
        this.fontRenderer = mc.field_71466_p;
        this.setFadeColors(0, 0);
        this.setScrollBarColors(Integer.MIN_VALUE, -2130706433, -1073741824);
    }

    public WidgetInfoBox addHeader(List<String> lines) {
        this.lines = this.resizeContent(lines);
        this.setRenderHeader(true, this.getHeaderHeight());
        return this;
    }

    private List<ITextComponent> resizeContent(List<String> lines) {
        ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
        for (String line : lines) {
            if (line == null) {
                ret.add(null);
                continue;
            }
            ITextComponent chat = ForgeHooks.newChatWithLinks((String)line, (boolean)false);
            ret.addAll(RenderComponentsUtil.func_178908_a((ITextComponent)chat, (int)(this.getRowWidth() - 8), (FontRenderer)this.fontRenderer, (boolean)false, (boolean)false));
        }
        return ret;
    }

    private int getHeaderHeight() {
        int size = this.getBottom() - this.getTop() - 8;
        int height = 0;
        if ((height += this.lines.size() * 10) < size) {
            height = size;
        }
        return height;
    }

    protected void renderHeader(int relativeX, int relativeY, Tessellator tess) {
        int top = relativeY;
        for (ITextComponent line : this.lines) {
            if (line != null && top > this.y0 - 10 && top < this.y1) {
                GlStateManager.enableBlend();
                this.fontRenderer.func_175063_a(line.func_150254_d(), (float)(this.x0 + 4), (float)top, 0xFFFFFF);
                GlStateManager.disableAlphaTest();
                GlStateManager.disableBlend();
            }
            top += 10;
        }
    }

    @Override
    protected int getScrollbarPosition() {
        return this.x1 - 6;
    }

    @Override
    public int getRowWidth() {
        return this.width;
    }

    public void setInfo(Entry info) {
        this.clearEntries();
        this.addEntry((AbstractList.AbstractListEntry)info);
    }

    public void clear() {
        this.clearEntries();
    }

    @Override
    protected void renderBackground(Tessellator tessellator, BufferBuilder bufferbuilder) {
    }

    protected void renderHoleBackground(int x0, int y0, int x1, int y1) {
    }

    public static class Entry
    extends ExtendedList.AbstractListEntry<Entry> {
        public void render(int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
        }
    }
}

