/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@OnlyIn(value=Dist.CLIENT)
public class TintedOBJ {
    private static Random random = new Random();

    public static OBJModel.OBJBakedModel create(ResourceLocation location, int tintIndex, OBJModel.OBJBakedModel original, Function<ResourceLocation, TextureAtlasSprite> spriteGetter) {
        boolean failed = false;
        List quads = original.getQuads(Blocks.field_150350_a.func_176223_P(), null, random, (IModelData)EmptyModelData.INSTANCE);
        try {
            for (Object quad : quads) {
                ObfuscationReflectionHelper.setPrivateValue(BakedQuad.class, (Object)quad, (Object)tintIndex, (String)"field_178213_b");
            }
        }
        catch (Exception ignored) {
            failed = true;
        }
        if (!failed) {
            return original;
        }
        ArrayList tinted = Lists.newArrayList();
        for (BakedQuad quad : quads) {
            tinted.add(new TintedBakedQuad(quad, tintIndex));
        }
        OBJModel.MaterialLibrary library = original.getModel().getMatLib();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ModelLoader.White.LOCATION.toString(), (Object)ModelLoader.White.INSTANCE);
        TextureAtlasSprite missing = spriteGetter.apply(new ResourceLocation("missingno"));
        ImmutableList materialNames = library.getMaterialNames();
        for (String material : materialNames) {
            OBJModel.Material mat = library.getMaterial(material);
            if (mat.getTexture().getTextureLocation().func_110623_a().startsWith("#")) {
                builder.put((Object)material, (Object)missing);
                continue;
            }
            builder.put((Object)material, (Object)spriteGetter.apply(mat.getTexture().getTextureLocation()));
        }
        builder.put((Object)"missingno", (Object)missing);
        return new TintedBakedModel(location, original, (ImmutableList<BakedQuad>)ImmutableList.copyOf((Collection)tinted), ((BakedQuad)quads.get(0)).getFormat(), (ImmutableMap<String, TextureAtlasSprite>)builder.build());
    }

    private static class TintedBakedModel
    extends OBJModel.OBJBakedModel {
        private final ImmutableList<BakedQuad> quads;

        public TintedBakedModel(ResourceLocation location, OBJModel.OBJBakedModel model, ImmutableList<BakedQuad> quads, VertexFormat format, ImmutableMap<String, TextureAtlasSprite> textures) {
            OBJModel oBJModel = new OBJModel(model.getModel().getMatLib(), location);
            oBJModel.getClass();
            super(oBJModel, model.getModel(), model.getState(), format, textures);
            this.quads = quads;
        }

        public List<BakedQuad> getQuads(BlockState blockState, Direction side, Random rand, IModelData modelData) {
            return this.quads;
        }
    }

    private static class TintedBakedQuad
    extends BakedQuad {
        public TintedBakedQuad(BakedQuad quad, int tintIndex) {
            super(quad.func_178209_a(), tintIndex, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
        }
    }
}

