/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import shetiphian.core.common.network.PacketBase;

public abstract class PacketPipeline {
    private final SimpleChannel wrapper;

    public PacketPipeline(String modId, String version) {
        this.wrapper = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(modId, "main_channel")).networkProtocolVersion(() -> version).clientAcceptedVersions(version::equals).serverAcceptedVersions(version::equals).simpleChannel();
        this.registerPackets(this.wrapper);
    }

    public abstract void registerPackets(SimpleChannel var1);

    public static void onMessage(PacketBase packet, Supplier<NetworkEvent.Context> ctx) {
        switch (ctx.get().getDirection()) {
            case PLAY_TO_CLIENT: 
            case LOGIN_TO_CLIENT: {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketPipeline.lambda$null$1(packet, (Supplier)ctx));
                break;
            }
            case PLAY_TO_SERVER: 
            case LOGIN_TO_SERVER: {
                ctx.get().enqueueWork(() -> packet.handleServerSide((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender()));
            }
        }
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onMessageClient(PacketBase packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> packet.handleClientSide((PlayerEntity)Minecraft.func_71410_x().field_71439_g));
    }

    public void sendPacketToServer(PacketBase packet) {
        this.wrapper.sendToServer((Object)packet);
    }

    public void sendPacketToPlayer(PacketBase packet, ServerPlayerEntity player) {
        this.wrapper.sendTo((Object)packet, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void sendPacketToList(PacketBase packet, List<ServerPlayerEntity> players) {
        for (ServerPlayerEntity player : players) {
            this.sendPacketToPlayer(packet, player);
        }
    }

    public void sendPacketToAll(PacketBase packet) {
        this.sendPacketToList(packet, this.getPlayers());
    }

    public void sendPacketToAllAround(PacketBase packet, Entity entity, double range) {
        this.sendPacketToAllAround(packet, entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, range);
    }

    public void sendPacketToAllAround(PacketBase packet, DimensionType dimension, BlockPos pos, double range) {
        this.sendPacketToAllAround(packet, dimension, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), range);
    }

    public void sendPacketToAllAround(PacketBase packet, DimensionType dimension, double x, double y, double z, double range) {
        for (ServerPlayerEntity player : this.getPlayers()) {
            double posZ;
            double posY;
            double posX;
            if (player.field_71093_bK != dimension || !((posX = x - player.field_70165_t) * posX + (posY = y - player.field_70163_u) * posY + (posZ = z - player.field_70161_v) * posZ < range * range)) continue;
            this.sendPacketToPlayer(packet, player);
        }
    }

    public void sendPacketToDimension(PacketBase packet, DimensionType dimension) {
        for (ServerPlayerEntity player : this.getPlayers()) {
            if (player.field_71093_bK != dimension) continue;
            this.sendPacketToPlayer(packet, player);
        }
    }

    private List<ServerPlayerEntity> getPlayers() {
        PlayerList playerList = null;
        try {
            playerList = ServerLifecycleHooks.getCurrentServer().func_184103_al();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return playerList != null ? playerList.func_181057_v() : new ArrayList();
    }

    private static /* synthetic */ void lambda$null$1(PacketBase packet, Supplier ctx) {
        PacketPipeline.onMessageClient(packet, ctx);
    }
}

