/**
 * Enables blocks thinner then 0.2F to have particles and acknowledge when an entity walks on them.
 *
 * This is done by making the total subtracted 0.0625 (1/16th of a block)
 * [actually a bit more due to rounding, but correcting for that makes carpet have particles thus changing vanilla block behaviour]
 *
 * Before: MathHelper.floor(this.posY - (double)0.2F);
 * After: MathHelper.floor(this.posY + 0.1375D - (double)0.2F);
 *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Made with help from:
 * https://cadiboo.github.io/tutorials/1.13.2/forge/99.99-coremod/
 * https://raw.githubusercontent.com/Cadiboo/NoCubes/1.14.x/src/main/resources/nocubes-transformer.js
 */

function initializeCoreMod() {
    Opcodes = Java.type("org.objectweb.asm.Opcodes");
    ASMAPI = Java.type("net.minecraftforge.coremod.api.ASMAPI");
    InsnList = Java.type("org.objectweb.asm.tree.InsnList");
    LdcInsn = Java.type("org.objectweb.asm.tree.LdcInsnNode");
    Insn = Java.type("org.objectweb.asm.tree.InsnNode");

    return {
        "Entity.move": {
            "target": {
                "type": "METHOD",
                "class": "net.minecraft.entity.Entity",
                "methodName": ASMAPI.mapMethod("func_213315_a"),
                "methodDesc": "(Lnet/minecraft/entity/MoverType;Lnet/minecraft/util/math/Vec3d;)V"
            },
            "transformer": function(methodNode) {
                print("Starting Transform: ShetiPhianCore/recognise-thinner-blocks.js 'Entity.move'");
                inject(methodNode.instructions, "net/minecraft/entity/Entity", ASMAPI.mapField("field_70163_u"));
                return methodNode;
            }
        },
        "Entity.createRunningParticles": {
            "target": {
                "type": "METHOD",
                "class": "net.minecraft.entity.Entity",
                "methodName": ASMAPI.mapMethod("func_174808_Z"),
                "methodDesc": "()V"
            },
            "transformer": function(methodNode) {
                print("Starting Transform: ShetiPhianCore/recognise-thinner-blocks.js 'Entity.createRunningParticles'");
                inject(methodNode.instructions, "net/minecraft/entity/Entity", ASMAPI.mapField("field_70163_u"));
                return methodNode;
            }
        },
        "LivingEntity.fall": {
            "target": {
                "type": "METHOD",
                "class": "net.minecraft.entity.LivingEntity",
                "methodName": ASMAPI.mapMethod("func_180430_e"),
                "methodDesc": "(FF)V"
            },
            "transformer": function(methodNode) {
                print("Starting Transform: ShetiPhianCore/recognise-thinner-blocks.js 'LivingEntity.fall'");
                inject(methodNode.instructions, "net/minecraft/entity/LivingEntity", ASMAPI.mapField("field_70163_u"));
                return methodNode;
            }
        },
        "IronGolemEntity.livingTick": {
            "target": {
                "type": "METHOD",
                "class": "net.minecraft.entity.passive.IronGolemEntity",
                "methodName": ASMAPI.mapMethod("func_70636_d"),
                "methodDesc": "()V"
            },
            "transformer": function(methodNode) {
                print("Starting Transform: ShetiPhianCore/recognise-thinner-blocks.js 'IronGolemEntity.livingTick'");
                inject(methodNode.instructions, "net/minecraft/entity/passive/IronGolemEntity", ASMAPI.mapField("field_70163_u"));
                return methodNode;
            }
        },
        "ServerPlayerEntity.handleFalling": {
            "target": {
                "type": "METHOD",
                "class": "net.minecraft.entity.player.ServerPlayerEntity",
                "methodName": ASMAPI.mapMethod("func_71122_b"),
                "methodDesc": "(DZ)V"
            },
            "transformer": function(methodNode) {
                print("Starting Transform: ShetiPhianCore/recognise-thinner-blocks.js 'ServerPlayerEntity.handleFalling'");
                inject(methodNode.instructions, "net/minecraft/entity/player/ServerPlayerEntity", ASMAPI.mapField("field_70163_u"));
                return methodNode;
            }
        }
    };
}

function inject(instructions, method_name, field_name) {
    var findme = ASMAPI.mapField(field_name);
    var found;
    for (var i = 0; i < instructions.size(); ++i) {
        var instruction = instructions.get(i);
        if (instruction.getOpcode() == Opcodes.GETFIELD) {
            if (instruction.owner == method_name) {
                if (instruction.name == findme) {
                    if (instruction.desc == "D") {
                        found = instruction;
                        print("Found injection point '" + method_name + "." + field_name + "' " + instruction);
                        break;
                    }
                }
            }
        }
    }
    if (!found) {
        throw "Error: Couldn't find injection point '" + method_name + "." + field_name + "'!";
    }
    var toInject = new InsnList();
    toInject.add(new LdcInsn(0.1375));
    toInject.add(new Insn(Opcodes.DADD));
    instructions.insert(found, toInject);
    print("Instructions Injected");
}