/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.backport;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;

public class EnumFacingHelper {
    public static final EnumFacing[] VALUES = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    public static final EnumFacing[] HORIZONTALS = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.EAST};

    public static EnumFacing getHorizontal(int index) {
        return HORIZONTALS[MathHelper.func_76130_a((int)(index % HORIZONTALS.length))];
    }

    public static int getHorizontalIndex(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 0;
            }
            case WEST: {
                return 1;
            }
            case EAST: {
                return 3;
            }
        }
        return -1;
    }

    public static String getName(EnumFacing facing) {
        return facing.name().toLowerCase();
    }

    public static EnumFacing byName(String name) {
        for (EnumFacing facing : EnumFacing.values()) {
            if (!facing.name().equalsIgnoreCase(name)) continue;
            return facing;
        }
        return EnumFacing.SOUTH;
    }

    public static EnumFacing getOpposite(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return EnumFacing.UP;
            }
            case UP: {
                return EnumFacing.DOWN;
            }
            case NORTH: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.NORTH;
            }
            case WEST: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.SOUTH;
    }

    public static EnumFacing rotateAround(EnumFacing facing, Axis axis) {
        switch (axis) {
            case X: {
                if (facing != EnumFacing.WEST && facing != EnumFacing.EAST) {
                    return EnumFacingHelper.rotateX(facing);
                }
                return facing;
            }
            case Y: {
                if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
                    return EnumFacingHelper.rotateY(facing);
                }
                return facing;
            }
            case Z: {
                if (facing != EnumFacing.NORTH && facing != EnumFacing.SOUTH) {
                    return EnumFacingHelper.rotateZ(facing);
                }
                return facing;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + (Object)((Object)axis));
    }

    public static EnumFacing rotateY(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.NORTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + facing);
    }

    public static EnumFacing rotateX(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return EnumFacing.DOWN;
            }
            case DOWN: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.UP;
            }
            case UP: {
                return EnumFacing.NORTH;
            }
        }
        throw new IllegalStateException("Unable to get X-rotated facing of " + facing);
    }

    public static EnumFacing rotateZ(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return EnumFacing.DOWN;
            }
            case DOWN: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.UP;
            }
            case UP: {
                return EnumFacing.EAST;
            }
        }
        throw new IllegalStateException("Unable to get Z-rotated facing of " + facing);
    }

    public static EnumFacing rotateYCCW(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.NORTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW facing of " + facing);
    }

    public static Axis getAxis(EnumFacing facing) {
        switch (facing) {
            case DOWN: 
            case UP: {
                return Axis.Y;
            }
            case NORTH: 
            case SOUTH: {
                return Axis.Z;
            }
            case WEST: 
            case EAST: {
                return Axis.X;
            }
        }
        return Axis.Z;
    }

    public static enum Axis {
        X,
        Y,
        Z;

    }
}

