/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import shetiphian.core.common.network.PacketBase;

public abstract class PacketPipeline {
    private SimpleNetworkWrapper network;

    public void initalise(String channelName) {
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel(channelName);
        this.registerPackets(this.network);
    }

    public abstract void registerPackets(SimpleNetworkWrapper var1);

    public static void onMessage(PacketBase packet, MessageContext ctx) {
        switch (ctx.side) {
            case CLIENT: {
                packet.handleClientSide(PacketPipeline.getClientPlayer());
                break;
            }
            case SERVER: {
                packet.handleServerSide((EntityPlayer)ctx.getServerHandler().field_147369_b);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void sendPacketToAll(PacketBase packet) {
        this.network.sendToAll((IMessage)packet);
    }

    public void sendPacketToPlayer(PacketBase packet, EntityPlayerMP player) {
        this.network.sendTo((IMessage)packet, player);
    }

    public void sendPacketToAllAround(PacketBase packet, NetworkRegistry.TargetPoint point) {
        this.network.sendToAllAround((IMessage)packet, point);
    }

    public void sendPacketToDimension(PacketBase packet, int dimensionId) {
        this.network.sendToDimension((IMessage)packet, dimensionId);
    }

    public void sendPacketToServer(PacketBase packet) {
        this.network.sendToServer((IMessage)packet);
    }
}

