/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client;

import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;

@SideOnly(value=Side.CLIENT)
public abstract class SoundHandler {
    private Minecraft mc = FMLClientHandler.instance().getClient();

    @SubscribeEvent
    public void playSound(PlaySoundEvent event) {
        if (event.category == SoundCategory.BLOCKS || event.category == SoundCategory.ANIMALS || event.category == null) {
            ISound sound = event.sound;
            event.result = this.onPlaySound(sound, event.name, sound.func_147653_e(), sound.func_147655_f(), sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i());
        }
    }

    protected abstract ISound onPlaySpecialSound(ISound var1, String var2, float var3, float var4, int var5, int var6, int var7);

    protected abstract ISound onPlayPlaceBreakSound(ISound var1, String var2, float var3, float var4, int var5, int var6, int var7, IBlockState var8);

    protected abstract ISound onPlayWalkFallSound(ISound var1, String var2, float var3, float var4, int var5, int var6, int var7, IBlockState var8);

    private ISound onPlaySound(ISound sound, String name, float volume, float pitch, float sx, float sy, float sz) {
        ISound newSound;
        IBlockState state;
        ISound newSound2;
        int[] blockXZ = Function.getBlockXZ(sx, sz);
        int x = blockXZ[0];
        int z = blockXZ[1];
        int y = (int)sy;
        if (sy - (float)y > 0.0f) {
            ++y;
        }
        if (!name.startsWith("dig") && !name.startsWith("step") && sound != (newSound2 = this.onPlaySpecialSound(sound, name, volume, pitch, x, y, z))) {
            return newSound2;
        }
        if (name.startsWith("dig")) {
            state = this.mc.field_71441_e.func_180495_p(new BlockPos(x, y, z));
            if (state.func_177230_c() instanceof BlockAir) {
                state = this.mc.field_71441_e.func_180495_p(new BlockPos(x, y - 1, z));
            }
            if (sound != (newSound = this.onPlayPlaceBreakSound(sound, name, volume, pitch, x, y, z, state))) {
                return newSound;
            }
        }
        if (name.startsWith("step") && sound != (newSound = this.onPlayWalkFallSound(sound, name, volume, pitch, x, y, z, state = this.mc.field_71441_e.func_180495_p(new BlockPos(x, y - 1, z))))) {
            return newSound;
        }
        return sound;
    }

    protected ISound getPlaceSound(Block.SoundType sound, float volume, float pitch, float x, float y, float z) {
        return this.getSound(sound.func_150496_b(), volume, pitch, x, y, z);
    }

    protected ISound getBreakSound(Block.SoundType sound, float volume, float pitch, float x, float y, float z) {
        return this.getSound(sound.func_150495_a(), volume, pitch, x, y, z);
    }

    protected ISound getStepSound(Block.SoundType sound, float volume, float pitch, float x, float y, float z) {
        return this.getSound(sound.func_150498_e(), volume, pitch, x, y, z);
    }

    protected ISound getSound(String name, float volume, float pitch, float x, float y, float z) {
        return new PositionedSoundRecord(new ResourceLocation(name), volume, pitch, x, y, z);
    }
}

