/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.util.IRegistry;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.b3d.B3DModel;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.model.AdjustedOBJBakedModel;
import shetiphian.core.client.model.MultiLayerModel;
import shetiphian.core.client.model.WeightedMultiLayerModel;

@SideOnly(value=Side.CLIENT)
public class ModelConvert {
    public static final ModelConvert INSTANCE = new ModelConvert();

    public void toMultiLayer(Block block, IRegistry<ModelResourceLocation, IBakedModel> registry) {
        this.toMultiLayer(block, registry, null);
    }

    public void toMultiLayer(Block block, IRegistry<ModelResourceLocation, IBakedModel> registry, MultiStateMapper mapper) {
        if (block == null || registry == null) {
            return;
        }
        for (IBlockState iBlockState : block.func_176194_O().func_177619_a()) {
            ModelResourceLocation resource = StateMapper.INSTANCE.getResource(iBlockState, mapper);
            Object model = registry.func_82594_a((Object)resource);
            if (model instanceof OBJModel.OBJBakedModel || model instanceof B3DModel) continue;
            if (model instanceof WeightedBakedModel) {
                registry.func_82595_a((Object)resource, (Object)new WeightedMultiLayerModel((WeightedBakedModel)model, Attributes.DEFAULT_BAKED_FORMAT));
                continue;
            }
            if (model == null) continue;
            registry.func_82595_a((Object)resource, (Object)new MultiLayerModel((IBakedModel)model, Attributes.DEFAULT_BAKED_FORMAT));
        }
    }

    public void toAdjustedOBJ(ModelResourceLocation location, IRegistry<ModelResourceLocation, IBakedModel> registry) {
        if (Loader.isModLoaded((String)"itemtransformhelper")) {
            return;
        }
        if (location == null || registry == null) {
            return;
        }
        Object model = registry.func_82594_a((Object)location);
        if (model instanceof OBJModel.OBJBakedModel) {
            registry.func_82595_a((Object)location, (Object)new AdjustedOBJBakedModel((OBJModel.OBJBakedModel)model, location.toString()));
        }
    }

    public static abstract class MultiStateMapper
    extends StateMapperBase {
        protected ModelResourceLocation getModelResource(IBlockState state) {
            return this.func_178132_a(state);
        }
    }

    public static class StateMapper
    extends DefaultStateMapper {
        public static final StateMapper INSTANCE = new StateMapper();

        protected ModelResourceLocation getResource(IBlockState state, MultiStateMapper mapper) {
            if (mapper != null) {
                return mapper.getModelResource(state);
            }
            return this.func_178132_a(state);
        }
    }
}

