/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
class MultiLayerModel
implements IFlexibleBakedModel {
    private final IBakedModel original;
    private final VertexFormat format;
    private Table<String, String, List<BakedQuad>> tableQuads = HashBasedTable.create();

    MultiLayerModel(IBakedModel original, VertexFormat format) {
        this.original = original;
        this.format = format;
        Map<String, List<BakedQuad>> tempMap = this.getQuadsSorted(original.func_177550_a());
        for (Map.Entry<String, List<BakedQuad>> entry : tempMap.entrySet()) {
            this.tableQuads.put((Object)"general", (Object)entry.getKey(), entry.getValue());
        }
        for (EnumFacing facing : EnumFacing.values()) {
            tempMap = this.getQuadsSorted(original.func_177551_a(facing));
            for (Map.Entry<String, List<BakedQuad>> entry : tempMap.entrySet()) {
                this.tableQuads.put((Object)this.clean(facing), (Object)entry.getKey(), entry.getValue());
            }
        }
    }

    private Map<String, List<BakedQuad>> getQuadsSorted(List<BakedQuad> baseQuads) {
        ArrayList<BakedQuad> buildSolid = new ArrayList<BakedQuad>();
        ArrayList<BakedQuad> buildTranslucent = new ArrayList<BakedQuad>();
        ArrayList<BakedQuad> buildCutout = new ArrayList<BakedQuad>();
        block4: for (BakedQuad quad : baseQuads) {
            switch (quad.func_178211_c() / 5) {
                case 1: {
                    buildCutout.add(quad);
                    continue block4;
                }
                case 2: {
                    buildTranslucent.add(quad);
                    continue block4;
                }
            }
            buildSolid.add(quad);
        }
        HashMap<String, List<BakedQuad>> mapQuads = new HashMap<String, List<BakedQuad>>();
        mapQuads.put(this.clean(EnumWorldBlockLayer.SOLID), buildSolid);
        mapQuads.put(this.clean(EnumWorldBlockLayer.TRANSLUCENT), buildTranslucent);
        mapQuads.put(this.clean(EnumWorldBlockLayer.CUTOUT), buildCutout);
        return mapQuads;
    }

    private String clean(String input) {
        return input.toLowerCase().trim();
    }

    private String clean(EnumWorldBlockLayer layer) {
        return this.clean(layer.toString());
    }

    private String clean(EnumFacing facing) {
        return this.clean(facing.func_176610_l());
    }

    private String getLayerKey() {
        EnumWorldBlockLayer layer = MinecraftForgeClient.getRenderLayer();
        return this.clean(layer == EnumWorldBlockLayer.CUTOUT_MIPPED ? EnumWorldBlockLayer.CUTOUT : layer);
    }

    public List<BakedQuad> func_177551_a(EnumFacing facing) {
        String layer;
        String face = this.clean(facing);
        return this.tableQuads.contains((Object)face, (Object)(layer = this.getLayerKey())) ? (List)this.tableQuads.get((Object)face, (Object)layer) : Collections.emptyList();
    }

    public List<BakedQuad> func_177550_a() {
        String layer = this.getLayerKey();
        return this.tableQuads.contains((Object)"general", (Object)layer) ? (List)this.tableQuads.get((Object)"general", (Object)layer) : Collections.emptyList();
    }

    public boolean func_177555_b() {
        return this.original.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.original.func_177556_c();
    }

    public boolean func_177553_d() {
        return this.original.func_177553_d();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.original.func_177554_e();
    }

    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return this.original.func_177552_f();
    }

    public VertexFormat getFormat() {
        return this.format;
    }
}

