/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.model.MultiLayerModel;

@SideOnly(value=Side.CLIENT)
class WeightedMultiLayerModel
extends WeightedBakedModel
implements IFlexibleBakedModel {
    private final int totalWeight;
    private final List<WeighedItem> listModels;
    private final IBakedModel baseModel;
    private final VertexFormat format;
    private static Field fieldModel;

    WeightedMultiLayerModel(WeightedBakedModel original, VertexFormat format) {
        super(WeightedMultiLayerModel.getDummy(original, format));
        this.format = format;
        if (fieldModel == null) {
            WeightedMultiLayerModel.getFieldModel();
        }
        Builder builder = new Builder();
        if (fieldModel != null) {
            for (Object entry : original.field_177565_b) {
                Object subModel = null;
                try {
                    subModel = fieldModel.get(entry);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(subModel instanceof IBakedModel)) continue;
                MultiLayerModel newModel = new MultiLayerModel((IBakedModel)subModel, format);
                builder = builder.add((IBakedModel)newModel, ((WeightedRandom.Item)entry).field_76292_a);
            }
        }
        if (builder.all().isEmpty()) {
            builder = builder.add((IBakedModel)new MultiLayerModel((IBakedModel)original, format), 1);
        }
        this.listModels = builder.all();
        this.totalWeight = WeightedRandom.func_76272_a(this.listModels);
        this.baseModel = this.listModels.get((int)0).model;
    }

    private static List getDummy(WeightedBakedModel original, VertexFormat format) {
        WeightedBakedModel.Builder builder = new WeightedBakedModel.Builder().func_177677_a((IBakedModel)new MultiLayerModel((IBakedModel)original, format), 1);
        return builder.func_177676_a().field_177565_b;
    }

    private static void getFieldModel() {
        Class<?> MyWeighedRandomItem = null;
        Constructor<?> construct = null;
        for (Class<?> clazz : WeightedBakedModel.class.getDeclaredClasses()) {
            try {
                construct = clazz.getDeclaredConstructor(IBakedModel.class, Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (construct == null) continue;
            MyWeighedRandomItem = clazz;
            break;
        }
        if (MyWeighedRandomItem != null && fieldModel == null) {
            for (AnnotatedElement annotatedElement : MyWeighedRandomItem.getDeclaredFields()) {
                if (!((Field)annotatedElement).getType().equals(IBakedModel.class)) continue;
                ((Field)annotatedElement).setAccessible(true);
                fieldModel = annotatedElement;
                fieldModel.setAccessible(true);
                break;
            }
        }
    }

    public List<BakedQuad> func_177551_a(EnumFacing facing) {
        return this.baseModel.func_177551_a(facing);
    }

    public List<BakedQuad> func_177550_a() {
        return this.baseModel.func_177550_a();
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.baseModel.func_177556_c();
    }

    public boolean func_177553_d() {
        return this.baseModel.func_177553_d();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.baseModel.func_177552_f();
    }

    public IBakedModel func_177564_a(long value) {
        return ((WeighedItem)WeightedRandom.func_180166_a(this.listModels, (int)(Math.abs((int)((int)value >> 16)) % this.totalWeight))).model;
    }

    public VertexFormat getFormat() {
        return this.format;
    }

    @SideOnly(value=Side.CLIENT)
    static class WeighedItem
    extends WeightedRandom.Item
    implements Comparable<WeighedItem> {
        protected final IBakedModel model;

        WeighedItem(IBakedModel model, int weight) {
            super(weight);
            this.model = model;
        }

        int getCountQuads() {
            int size = this.model.func_177550_a().size();
            for (EnumFacing facing : EnumFacing.values()) {
                size += this.model.func_177551_a(facing).size();
            }
            return size;
        }

        public String toString() {
            return "WeighedItem{weight=" + this.field_76292_a + ", model=" + this.model + '}';
        }

        @Override
        public int compareTo(WeighedItem item) {
            return ComparisonChain.start().compare(item.field_76292_a, this.field_76292_a).compare(this.getCountQuads(), item.getCountQuads()).result();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Builder {
        private List listItems = Lists.newArrayList();

        public Builder add(IBakedModel model, int weight) {
            this.listItems.add(new WeighedItem(model, weight));
            return this;
        }

        public WeightedBakedModel build() {
            Collections.sort(this.listItems);
            return new WeightedBakedModel(this.listItems);
        }

        public List<WeighedItem> all() {
            return this.listItems;
        }
    }
}

