/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import joptsimple.internal.Strings;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class Function {
    public static final String[] dyeNamesWB = new String[]{"dyeWhite", "dyeOrange", "dyeMagenta", "dyeLightBlue", "dyeYellow", "dyeLime", "dyePink", "dyeGray", "dyeLightGray", "dyeCyan", "dyePurple", "dyeBlue", "dyeBrown", "dyeGreen", "dyeRed", "dyeBlack"};
    public static final String[] dyeNamesBW = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
    private static final HashMap<String, List<ItemStack>> cache = new HashMap();
    public static Random random = new Random();

    public static boolean setBlock(World world, BlockPos pos, IBlockState state, boolean notify) {
        int update = notify ? 3 : 2;
        return world.func_180501_a(pos, state, update);
    }

    public static void removeBlock(World world, BlockPos pos, boolean notify) {
        if (notify) {
            world.func_175698_g(pos);
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
        world.func_175713_t(pos);
    }

    public static void syncTile(TileEntity tile) {
        tile.func_70296_d();
        tile.func_145831_w().func_175689_h(tile.func_174877_v());
    }

    public static Block getBlockDown(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c();
    }

    public static int[] getBlockXZ(double posX, double posZ) {
        int blockX = (int)posX;
        int blockZ = (int)posZ;
        if (posX - (double)((int)posX) < 0.0) {
            --blockX;
        }
        if (posZ - (double)((int)posZ) < 0.0) {
            // empty if block
        }
        return new int[]{blockX, --blockZ};
    }

    public static boolean giveItem(EntityPlayer player, ItemStack stack) {
        return Function.giveItem(player, stack, "random.pop");
    }

    public static boolean giveItem(EntityPlayer player, ItemStack stack, String sound) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            Function.dropItem(player.field_70170_p, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), stack);
            return false;
        }
        if (!Strings.isNullOrEmpty((String)sound)) {
            player.field_70170_p.func_72956_a((Entity)player, sound, 0.2f, ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        return true;
    }

    public static void dropItem(World world, BlockPos pos, ItemStack stack) {
        if (!world.field_72995_K && stack != null) {
            double rndX = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double rndY = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double rndZ = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + rndX, (double)pos.func_177956_o() + rndY, (double)pos.func_177952_p() + rndZ, stack);
            entityItem.func_174867_a(10);
            if (stack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entityItem);
        }
    }

    public static ItemStack findItemStack(String modId, String name, int stackSize) {
        ItemStack foundStack = Function.findItemStack(modId, name);
        if (foundStack != null && foundStack.func_77973_b() != null) {
            ItemStack stack = foundStack.func_77946_l();
            stack.field_77994_a = Math.min(stackSize, stack.func_77976_d());
            return stack;
        }
        return null;
    }

    public static ItemStack findItemStack(String modId, String name) {
        Item item = GameRegistry.findItem((String)modId, (String)name);
        if (item != null) {
            return new ItemStack(item, 1, 0);
        }
        Block block = GameRegistry.findBlock((String)modId, (String)name);
        if (block != null) {
            ItemStack stack = new ItemStack(block, 1, Short.MAX_VALUE);
            return stack.func_77973_b() != null ? stack : null;
        }
        return null;
    }

    public static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        return Function.areItemStacksEqual(stackA, stackB, false);
    }

    public static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB, boolean excludeNBT) {
        boolean areEqual;
        if (stackA == null && stackB == null) {
            return true;
        }
        if (stackA == null || stackB == null) {
            return false;
        }
        boolean bl = areEqual = stackA.func_77973_b() == stackB.func_77973_b() && (stackA.func_77952_i() == stackB.func_77952_i() || stackA.func_77952_i() == Short.MAX_VALUE || stackB.func_77952_i() == Short.MAX_VALUE);
        return excludeNBT ? areEqual : areEqual && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    public static List<ItemStack> getOres(String name) {
        if (!cache.containsKey(name)) {
            cache.put(name, OreDictionary.getOres((String)name));
        }
        return cache.get(name);
    }

    public static ItemStack getOre(String name, int ... stackSize) {
        List<ItemStack> results;
        int amount;
        int n = amount = stackSize != null && stackSize.length > 0 ? stackSize[0] : 1;
        if (amount > 0 && (results = Function.getOres(name)) != null && !results.isEmpty()) {
            ItemStack stack = results.get(0);
            stack.field_77994_a = amount;
            return stack;
        }
        return null;
    }

    public static void attemptAdd(List<ItemStack> list, ItemStack itemStack) {
        if (itemStack != null && itemStack.field_77994_a > 0) {
            list.add(itemStack);
        }
    }

    public static String getEntityName(EntityLivingBase entity) {
        return entity.func_145748_c_().func_150260_c();
    }

    public static String getEntityName(ICommandSender sender) {
        return sender.func_145748_c_().func_150260_c();
    }

    public static boolean isOP(EntityPlayer player) {
        if (MinecraftServer.func_71276_C() == null) {
            return false;
        }
        if (MinecraftServer.func_71276_C().func_71264_H() && player.field_71075_bZ.field_75098_d) {
            return true;
        }
        String[] ops = null;
        try {
            ops = MinecraftServer.func_71276_C().func_71203_ab().func_152606_n();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ops != null) {
            for (String op : ops) {
                if (!op.equals(player.getDisplayNameString())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCreativeOP(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d && Function.isOP(player);
    }

    public static MovingObjectPosition fakeMOP(World world, BlockPos pos, EnumFacing face) {
        Vec3 vec3 = new Vec3((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        return new MovingObjectPosition(vec3, face, pos);
    }

    public static Entity getEntityInFront(World world, EntityPlayer player, double distance) {
        if (player == null || world == null || distance < 1.0) {
            return null;
        }
        Vec3 vecStart = new Vec3(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3 vecLook = player.func_70676_i(1.0f);
        Vec3 vecEnd = vecStart.func_72441_c(vecLook.field_72450_a * distance, vecLook.field_72448_b * distance, vecLook.field_72449_c * distance);
        EntityLiving theTarget = null;
        float closestHit = Float.POSITIVE_INFINITY;
        List entityList = player.field_70170_p.func_72872_a(EntityLiving.class, new AxisAlignedBB(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70165_t + 1.0, player.field_70163_u + 1.0, player.field_70161_v + 1.0).func_72314_b(distance, distance, distance));
        if (entityList.isEmpty()) {
            return null;
        }
        for (EntityLiving entity : entityList) {
            float currentHit;
            MovingObjectPosition intercept;
            AxisAlignedBB boundingBox;
            if (!entity.func_70067_L() || (boundingBox = entity.func_174813_aQ()) == null || (intercept = boundingBox.func_72327_a(vecStart, vecEnd)) == null || !((currentHit = (float)intercept.field_72307_f.func_72438_d(vecStart)) < closestHit) && currentHit != 0.0f) continue;
            closestHit = currentHit;
            theTarget = entity;
        }
        return theTarget;
    }

    public static BlockInfo getBlockInfront(World world, EntityPlayer player, double reach) {
        MovingObjectPosition mop = Function.getMovingObjectPositionFromPlayer(world, player, true, reach);
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return new BlockInfo(world, mop);
        }
        return null;
    }

    private static MovingObjectPosition getMovingObjectPositionFromPlayer(World world, EntityPlayer player, boolean includeLiquids, double reach) {
        if (player == null || world == null || reach < 1.0) {
            return null;
        }
        Vec3 vecStart = new Vec3(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3 vecLook = player.func_70676_i(1.0f);
        Vec3 vecEnd = vecStart.func_72441_c(vecLook.field_72450_a * reach, vecLook.field_72448_b * reach, vecLook.field_72449_c * reach);
        return world.func_147447_a(vecStart, vecEnd, includeLiquids, false, true);
    }

    public static class BlockInfo {
        public final BlockPos pos;
        public final IBlockState state;
        public final Block block;
        public final EnumFacing face;
        public final int sub;
        public final Vec3 vec;

        public BlockInfo(World world, MovingObjectPosition mop) {
            this.pos = mop.func_178782_a();
            this.state = world.func_180495_p(this.pos);
            this.block = this.state.func_177230_c();
            this.face = mop.field_178784_b;
            this.sub = mop.subHit;
            this.vec = mop.field_72307_f;
        }

        public String toString() {
            return "POS: " + this.pos + " -State: " + this.state + " -SideHit: " + this.face + " -SubHit: " + this.sub + " -HitVec: " + this.vec;
        }
    }
}

