/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ParticleHelper {
    public static IBlockState getStateForParticle(Entity entity, BlockPos pos, IBlockState state, Class blockType) {
        BlockPos pos2 = new BlockPos(pos.func_177958_n(), (int)Math.ceil(entity.field_70163_u) - 1, pos.func_177952_p());
        IBlockState state2 = entity.field_70170_p.func_180495_p(pos2);
        if (state2.func_177230_c().getClass().isInstance(blockType)) {
            pos = pos2;
            state = state2;
        }
        return ParticleHelper.getStateForParticle(state, entity.field_70170_p, pos);
    }

    public static IBlockState getStateForParticle(IBlockState state, World world, BlockPos pos) {
        return state.func_177230_c().func_176221_a(state, (IBlockAccess)world, pos);
    }

    public static boolean addLandingEffects(WorldServer world, EntityLivingBase entity, int numberOfParticles, int stateId) {
        world.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f, new int[]{stateId});
        return true;
    }

    public static boolean addRunningEffects(World world, Entity entity, int stateId) {
        world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, entity.field_70165_t + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.func_174813_aQ().field_72338_b + 0.1, entity.field_70161_v + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, new int[]{stateId});
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean addHitEffects(World world, BlockPos pos, EnumFacing facing, EffectRenderer effectRenderer, int particleStateId) {
        Block block = world.func_180495_p(pos).func_177230_c();
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        float f = 0.1f;
        double d0 = (double)i + world.field_73012_v.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(f * 2.0f)) + (double)f + block.func_149704_x();
        double d1 = (double)j + world.field_73012_v.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(f * 2.0f)) + (double)f + block.func_149665_z();
        double d2 = (double)k + world.field_73012_v.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(f * 2.0f)) + (double)f + block.func_149706_B();
        switch (facing) {
            case DOWN: {
                d1 = (double)j + block.func_149665_z() - (double)f;
                break;
            }
            case UP: {
                d1 = (double)j + block.func_149669_A() + (double)f;
                break;
            }
            case NORTH: {
                d2 = (double)k + block.func_149706_B() - (double)f;
                break;
            }
            case SOUTH: {
                d2 = (double)k + block.func_149693_C() + (double)f;
                break;
            }
            case WEST: {
                d0 = (double)i + block.func_149704_x() - (double)f;
                break;
            }
            case EAST: {
                d0 = (double)i + block.func_149753_y() + (double)f;
            }
        }
        EntityDiggingFX.Factory iparticlefactory = new EntityDiggingFX.Factory();
        EntityFX entityFX = iparticlefactory.func_178902_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), world, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{particleStateId});
        if (entityFX instanceof EntityDiggingFX) {
            effectRenderer.func_78873_a(((EntityDiggingFX)entityFX).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean addDestroyEffects(World world, BlockPos pos, EffectRenderer effectRenderer, int particleStateId) {
        EntityDiggingFX.Factory iparticlefactory = new EntityDiggingFX.Factory();
        int i = 4;
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < i; ++k) {
                for (int l = 0; l < i; ++l) {
                    double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / (double)i;
                    double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / (double)i;
                    double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / (double)i;
                    EntityFX entityFX = iparticlefactory.func_178902_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), world, d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, new int[]{particleStateId});
                    if (!(entityFX instanceof EntityDiggingFX)) continue;
                    effectRenderer.func_78873_a((EntityFX)((EntityDiggingFX)entityFX).func_174846_a(pos));
                }
            }
        }
        return true;
    }
}

