/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.item;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import shetiphian.core.common.MyDamageSource;

public abstract class ItemToolWithDamageSource
extends ItemTool {
    private MyDamageSource damageSource;

    public ItemToolWithDamageSource(float damage, Item.ToolMaterial material, MyDamageSource damageSource) {
        this(damage, material, damageSource, Sets.newHashSet((Object[])new Block[0]));
    }

    public ItemToolWithDamageSource(float damage, Item.ToolMaterial material, MyDamageSource damageSource, Set<Block> blocks) {
        super(damage, material, blocks);
        this.damageSource = damageSource;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity victim) {
        if (victim.func_70075_an() && !victim.func_85031_j((Entity)player)) {
            AttackValues values = ItemToolWithDamageSource.calculateBaseValues(player, victim, null);
            values.bonusDamage = this.getBonusDamage(player, victim, this.damageSource, values.damage, values.bonusDamage);
            values.knockback = this.getKnockback(player, victim, this.damageSource, values.knockback);
            if ((values.damage > 0.0f || values.bonusDamage > 0.0f) && ItemToolWithDamageSource.preformDamage(player, victim, this.damageSource, null, values)) {
                this.postHurtEntity(player, victim, this.damageSource);
            }
        }
        return true;
    }

    public static boolean onLeftClickEntity(EntityPlayer player, Entity victim, MyDamageSource damageSource, ItemStack extraModifiers) {
        AttackValues values;
        if (victim.func_70075_an() && !victim.func_85031_j((Entity)player) && ((values = ItemToolWithDamageSource.calculateBaseValues(player, victim, extraModifiers)).damage > 0.0f || values.bonusDamage > 0.0f) && ItemToolWithDamageSource.preformDamage(player, victim, damageSource, extraModifiers, values)) {
            player.func_71020_j(0.3f);
        }
        return true;
    }

    private static AttackValues calculateBaseValues(EntityPlayer player, Entity victim, ItemStack extraModifiers) {
        AttackValues values = new AttackValues();
        values.damage = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (victim instanceof EntityLivingBase) {
            values.bonusDamage = EnchantmentHelper.func_152377_a((ItemStack)player.func_70694_bm(), (EnumCreatureAttribute)((EntityLivingBase)victim).func_70668_bt());
            values.knockback = EnchantmentHelper.func_77501_a((EntityLivingBase)player);
            if (extraModifiers != null) {
                AttackValues attackValues = values;
                attackValues.bonusDamage = attackValues.bonusDamage + EnchantmentHelper.func_152377_a((ItemStack)extraModifiers, (EnumCreatureAttribute)((EntityLivingBase)victim).func_70668_bt());
                attackValues = values;
                attackValues.knockback = attackValues.knockback + EnchantmentHelper.func_77506_a((int)Enchantment.field_180313_o.field_77352_x, (ItemStack)extraModifiers);
            }
        }
        if (player.func_70051_ag()) {
            values.knockback++;
        }
        return values;
    }

    protected float getBonusDamage(EntityPlayer player, Entity victim, MyDamageSource source, float damage, float bonusDamage) {
        return bonusDamage;
    }

    protected int getKnockback(EntityPlayer player, Entity victim, MyDamageSource source, int knockback) {
        return knockback;
    }

    private static boolean preformDamage(EntityPlayer player, Entity victim, MyDamageSource damageSource, ItemStack extraModifiers, AttackValues values) {
        boolean victimWasHurt;
        AttackValues attackValues;
        boolean boostDamage;
        boolean bl = boostDamage = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.field_76440_q) && player.field_70154_o == null && victim instanceof EntityLivingBase;
        if (boostDamage && values.damage > 0.0f) {
            attackValues = values;
            attackValues.damage = attackValues.damage * 1.5f;
        }
        attackValues = values;
        attackValues.damage = attackValues.damage + values.bonusDamage;
        boolean victimOnFire = false;
        int fireDamage = EnchantmentHelper.func_90036_a((EntityLivingBase)player);
        if (extraModifiers != null) {
            fireDamage += EnchantmentHelper.func_77506_a((int)Enchantment.field_77334_n.field_77352_x, (ItemStack)extraModifiers);
        }
        if (victim instanceof EntityLivingBase && fireDamage > 0 && !victim.func_70027_ad()) {
            victim.func_70015_d(1);
            victimOnFire = true;
        }
        if (victimWasHurt = damageSource != null ? victim.func_70097_a(damageSource.causeEntityDamage((Entity)player), values.damage) : victim.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), values.damage)) {
            ItemStack equippedItem;
            IEntityMultiPart ientitymultipart;
            if (values.knockback > 0) {
                victim.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)values.knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)values.knockback * 0.5f));
                player.field_70159_w *= 0.6;
                player.field_70179_y *= 0.6;
                player.func_70031_b(false);
            }
            if (boostDamage) {
                player.func_71009_b(victim);
            }
            if (values.bonusDamage > 0.0f) {
                player.func_71047_c(victim);
            }
            if (values.damage >= 18.0f) {
                player.func_71029_a((StatBase)AchievementList.field_75999_E);
            }
            player.func_130011_c(victim);
            if (victim instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)victim), (Entity)player);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)player, (Entity)victim);
            Entity object = victim;
            if (victim instanceof EntityDragonPart && (ientitymultipart = ((EntityDragonPart)victim).field_70259_a) instanceof EntityLivingBase) {
                object = ientitymultipart;
            }
            if ((equippedItem = player.func_71045_bC()) != null && object instanceof EntityLivingBase) {
                equippedItem.func_77961_a((EntityLivingBase)object, player);
                if (equippedItem.field_77994_a <= 0) {
                    player.func_71028_bD();
                }
            }
            if (victim instanceof EntityLivingBase) {
                player.func_71064_a(StatList.field_75951_w, Math.round(values.damage * 10.0f));
                if (fireDamage > 0) {
                    victim.func_70015_d(fireDamage * 4);
                }
            }
        } else if (victimOnFire) {
            victim.func_70066_B();
        }
        return victimWasHurt;
    }

    protected void postHurtEntity(EntityPlayer player, Entity victim, MyDamageSource source) {
        player.func_71020_j(0.3f);
    }

    private static class AttackValues {
        private float damage;
        private int knockback;
        private float bonusDamage;

        private AttackValues() {
        }
    }
}

