/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.network;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.network.PacketBase;

public abstract class PacketPipeline {
    private SimpleNetworkWrapper wrapper;

    public void initialise(String channelName) {
        this.wrapper = NetworkRegistry.INSTANCE.newSimpleChannel(channelName.toLowerCase());
        this.registerPackets(this.wrapper);
    }

    public abstract void registerPackets(SimpleNetworkWrapper var1);

    public static void onMessage(PacketBase packet, MessageContext ctx) {
        switch (ctx.side) {
            case CLIENT: {
                packet.handleClientSide(PacketPipeline.getClientPlayer());
                break;
            }
            case SERVER: {
                packet.handleServerSide((EntityPlayer)ctx.getServerHandler().field_147369_b);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void sendPacketToServer(PacketBase packet) {
        this.wrapper.sendToServer((IMessage)packet);
    }

    public void sendPacketToPlayer(PacketBase packet, EntityPlayerMP player) {
        this.wrapper.sendTo((IMessage)packet, player);
    }

    public void sendPacketToList(PacketBase packet, List<EntityPlayerMP> players) {
        for (EntityPlayerMP player : players) {
            this.sendPacketToPlayer(packet, player);
        }
    }

    public void sendPacketToAll(PacketBase packet) {
    }

    public void sendPacketToAllAround(PacketBase packet, NetworkRegistry.TargetPoint point) {
    }

    public void sendPacketToDimension(PacketBase packet, int dimensionId) {
    }
}

