/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
class AdjustedOBJBakedModel
extends OBJModel.OBJBakedModel {
    private static Gson GSON = new GsonBuilder().registerTypeAdapter(ItemCameraTransforms.class, (Object)Deserializer.INSTANCE).create();
    private ItemCameraTransforms transforms;

    AdjustedOBJBakedModel(OBJModel.OBJBakedModel original, String location) {
        OBJModel oBJModel = original.getModel();
        oBJModel.getClass();
        super(oBJModel, original.getModel(), original.getState(), original.getFormat(), AdjustedOBJBakedModel.getTextures(original.getModel().getMatLib()));
        this.transforms = null;
        this.getTransforms(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTransforms(String location) {
        if (location.contains("#")) {
            location = location.substring(0, location.lastIndexOf(35));
        }
        location = "/assets/" + location.replace(":", "/models/item/").replace(".obj", ".json");
        InputStream inputstream = null;
        try {
            inputstream = AdjustedOBJBakedModel.class.getResourceAsStream(location);
            InputStreamReader reader = new InputStreamReader(inputstream, Charsets.UTF_8);
            byte[] data = IOUtils.toByteArray((Reader)reader);
            reader = new InputStreamReader((InputStream)new ByteArrayInputStream(data), Charsets.UTF_8);
            this.transforms = (ItemCameraTransforms)GSON.fromJson((Reader)reader, ItemCameraTransforms.class);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
    }

    private static ImmutableMap<String, TextureAtlasSprite> getTextures(OBJModel.MaterialLibrary matLib) {
        Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

            public TextureAtlasSprite apply(ResourceLocation location) {
                return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
            }
        };
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ModelLoader.White.loc.toString(), (Object)ModelLoader.White.instance);
        TextureAtlasSprite missing = (TextureAtlasSprite)bakedTextureGetter.apply((Object)new ResourceLocation("missingno"));
        for (String name : matLib.getMaterialNames()) {
            OBJModel.Material material = matLib.getMaterial(name);
            TextureAtlasSprite texture = material.getTexture().getTextureLocation().func_110623_a().startsWith("#") ? missing : (TextureAtlasSprite)bakedTextureGetter.apply((Object)material.getTexture().getTextureLocation());
            if (texture == null) continue;
            builder.put((Object)name, (Object)texture);
        }
        if (missing != null) {
            builder.put((Object)"missingno", (Object)missing);
        }
        return builder.build();
    }

    public IBakedModel handleItemState(ItemStack stack) {
        ModelResourceLocation resource = stack.func_77973_b().getModel(stack, (EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g, -127);
        AdjustedOBJBakedModel model = null;
        if (resource != null) {
            try {
                model = Minecraft.func_71410_x().getRenderItem().getItemModelMesher().getModelManager().getModel(resource);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return model != null ? model : this;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.transforms != null ? this.transforms : ItemCameraTransforms.field_178357_a;
    }

    public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation tr = new TRSRTransformation(this.func_177552_f().func_181688_b(cameraTransformType));
        return Pair.of((Object)((Object)this), (Object)TRSRTransformation.blockCornerToCenter((TRSRTransformation)tr).getMatrix());
    }

    public static class Deserializer
    implements JsonDeserializer<ItemCameraTransforms> {
        public static Deserializer INSTANCE = new Deserializer();
        private static final Vector3f ROTATION_DEFAULT = new Vector3f(0.0f, 0.0f, 0.0f);
        private static final Vector3f TRANSLATION_DEFAULT = new Vector3f(0.0f, 0.0f, 0.0f);
        private static final Vector3f SCALE_DEFAULT = new Vector3f(1.0f, 1.0f, 1.0f);

        public ItemCameraTransforms deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = json.getAsJsonObject();
            ItemCameraTransforms transforms = ItemCameraTransforms.field_178357_a;
            if (jsonobject.has("display")) {
                JsonObject jsonObject = JsonUtils.func_152754_s((JsonObject)jsonobject, (String)"display");
                transforms = this.deserialize(jsonObject);
            }
            return transforms;
        }

        private ItemCameraTransforms deserialize(JsonObject jsonobject) {
            ItemTransformVec3f vecThirdPerson = this.getVec3f(jsonobject, "thirdperson");
            ItemTransformVec3f vecFirstPerson = this.getVec3f(jsonobject, "firstperson");
            ItemTransformVec3f vecHead = this.getVec3f(jsonobject, "head");
            ItemTransformVec3f vecGUI = this.getVec3f(jsonobject, "gui");
            ItemTransformVec3f vecGround = this.getVec3f(jsonobject, "ground");
            ItemTransformVec3f vecFixed = this.getVec3f(jsonobject, "fixed");
            return new ItemCameraTransforms(vecThirdPerson, vecFirstPerson, vecHead, vecGUI, vecGround, vecFixed);
        }

        private ItemTransformVec3f getVec3f(JsonObject jsonobject, String name) {
            return jsonobject.has(name) ? this.deserializeVec3f(jsonobject.get(name)) : ItemTransformVec3f.field_178366_a;
        }

        private ItemTransformVec3f deserializeVec3f(JsonElement element) {
            JsonObject jsonobject = element.getAsJsonObject();
            Vector3f vecRotation = this.parseVector3f(jsonobject, "rotation", ROTATION_DEFAULT);
            Vector3f vecTranslation = this.parseVector3f(jsonobject, "translation", TRANSLATION_DEFAULT);
            vecTranslation.scale(0.0625f);
            MathHelper.clamp_double((double)vecTranslation.x, (double)-1.5, (double)1.5);
            MathHelper.clamp_double((double)vecTranslation.y, (double)-1.5, (double)1.5);
            MathHelper.clamp_double((double)vecTranslation.z, (double)-1.5, (double)1.5);
            Vector3f vecScale = this.parseVector3f(jsonobject, "scale", SCALE_DEFAULT);
            MathHelper.clamp_double((double)vecScale.x, (double)-1.5, (double)1.5);
            MathHelper.clamp_double((double)vecScale.y, (double)-1.5, (double)1.5);
            MathHelper.clamp_double((double)vecScale.z, (double)-1.5, (double)1.5);
            return new ItemTransformVec3f(vecRotation, vecTranslation, vecScale);
        }

        private Vector3f parseVector3f(JsonObject jsonObject, String key, Vector3f defaultValue) {
            if (!jsonObject.has(key)) {
                return defaultValue;
            }
            JsonArray jsonarray = JsonUtils.func_151214_t((JsonObject)jsonObject, (String)key);
            if (jsonarray.size() != 3) {
                throw new JsonParseException("Expected 3 " + key + " values, found: " + jsonarray.size());
            }
            float[] afloat = new float[3];
            for (int i = 0; i < afloat.length; ++i) {
                afloat[i] = JsonUtils.func_151220_d((JsonElement)jsonarray.get(i), (String)(key + "[" + i + "]"));
            }
            return new Vector3f(afloat[0], afloat[1], afloat[2]);
        }
    }
}

