/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.swampland;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.swampland.swampland;
import net.mcreator.swampland.swamplandVariables;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class Elementsswampland {
    protected final List<ModElement> elements = new ArrayList<ModElement>();
    protected final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    protected final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    protected final List<Supplier<Biome>> biomes = new ArrayList<Supplier<Biome>>();
    protected final List<Supplier<EntityType<?>>> entities = new ArrayList();
    private int messageID = 0;

    public Elementsswampland() {
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("swampland").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
        this.addNetworkMessage(swamplandVariables.WorldSavedDataSyncMessage.class, swamplandVariables.WorldSavedDataSyncMessage::buffer, swamplandVariables.WorldSavedDataSyncMessage::new, swamplandVariables.WorldSavedDataSyncMessage::handler);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        ResourceLocation sound0 = new ResourceLocation("swampland", "frog_living");
        event.getRegistry().register(new SoundEvent(sound0).setRegistryName(sound0));
        ResourceLocation sound1 = new ResourceLocation("swampland", "fly");
        event.getRegistry().register(new SoundEvent(sound1).setRegistryName(sound1));
        ResourceLocation sound2 = new ResourceLocation("swampland", "dragonfly");
        event.getRegistry().register(new SoundEvent(sound2).setRegistryName(sound2));
        ResourceLocation sound3 = new ResourceLocation("swampland", "alligator_living");
        event.getRegistry().register(new SoundEvent(sound3).setRegistryName(sound3));
        ResourceLocation sound4 = new ResourceLocation("swampland", "small_explosion");
        event.getRegistry().register(new SoundEvent(sound4).setRegistryName(sound4));
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            swamplandVariables.MapVariables mapdata = swamplandVariables.MapVariables.get(event.getPlayer().field_70170_p);
            swamplandVariables.WorldVariables worlddata = swamplandVariables.WorldVariables.get(event.getPlayer().field_70170_p);
            if (mapdata != null) {
                swampland.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new swamplandVariables.WorldSavedDataSyncMessage(0, mapdata));
            }
            if (worlddata != null) {
                swampland.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new swamplandVariables.WorldSavedDataSyncMessage(1, worlddata));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        swamplandVariables.WorldVariables worlddata;
        if (!event.getPlayer().field_70170_p.field_72995_K && (worlddata = swamplandVariables.WorldVariables.get(event.getPlayer().field_70170_p)) != null) {
            swampland.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new swamplandVariables.WorldSavedDataSyncMessage(1, worlddata));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        swampland.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<Biome>> getBiomes() {
        return this.biomes;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final Elementsswampland elements;
        protected final int sortid;

        public ModElement(Elementsswampland elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

