/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.crafting;

import com.google.gson.JsonObject;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.registries.ForgeRegistryEntry;
import toughasnails.api.crafting.TANRecipeSerializers;
import toughasnails.api.crafting.TANRecipeTypes;

public class WaterPurifierRecipe
implements IRecipe<IInventory> {
    protected final ResourceLocation id;
    protected final NBTIngredient ingredient;
    protected final ItemStack result;
    protected final int purifyTime;

    public WaterPurifierRecipe(ResourceLocation id, NBTIngredient ingredient, ItemStack result, int purifyTime) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
        this.purifyTime = purifyTime;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.ingredient.test(inv.func_70301_a(0));
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return TANRecipeSerializers.WATER_PURIFYING;
    }

    public IRecipeType<?> func_222127_g() {
        return TANRecipeTypes.WATER_PURIFYING;
    }

    public int getPurifyTime() {
        return this.purifyTime;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<WaterPurifierRecipe> {
        public WaterPurifierRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NBTIngredient ingredient = NBTIngredient.Serializer.INSTANCE.parse(JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            int purifyTime = JSONUtils.func_151208_a((JsonObject)json, (String)"purifytime", (int)200);
            return new WaterPurifierRecipe(recipeId, ingredient, result, purifyTime);
        }

        public WaterPurifierRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            NBTIngredient ingredient = (NBTIngredient)Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack result = buffer.func_150791_c();
            int purifyTime = buffer.readInt();
            return new WaterPurifierRecipe(recipeId, ingredient, result, purifyTime);
        }

        public void toNetwork(PacketBuffer buffer, WaterPurifierRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
            buffer.func_150788_a(recipe.result);
            buffer.writeInt(recipe.purifyTime);
        }
    }
}

