/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.item;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import toughasnails.api.block.TANBlocks;
import toughasnails.api.item.TANItems;
import toughasnails.block.RainCollectorBlock;
import toughasnails.config.ThirstConfig;

public class EmptyCanteenItem
extends Item {
    public EmptyCanteenItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        BlockPos pos;
        ItemStack stack = player.func_184586_b(hand);
        BlockRayTraceResult rayTraceResult = EmptyCanteenItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && world.func_175660_a(player, pos = rayTraceResult.func_216350_a())) {
            BlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof RainCollectorBlock) {
                int waterLevel = (Integer)state.func_177229_b((Property)RainCollectorBlock.LEVEL);
                if (waterLevel > 0 && !world.func_201670_d()) {
                    world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    ((RainCollectorBlock)TANBlocks.RAIN_COLLECTOR).setWaterLevel(world, pos, state, waterLevel - 1);
                    return ActionResult.func_226248_a_((Object)this.replaceCanteen(stack, player, new ItemStack((IItemProvider)TANItems.PURIFIED_WATER_CANTEEN)));
                }
            } else if (world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
                Item canteenItem;
                world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                RegistryKey biome = player.field_70170_p.func_242406_i(player.func_233580_cy_()).orElse(Biomes.field_76772_c);
                switch (ThirstConfig.getBiomeWaterType((RegistryKey<Biome>)biome)) {
                    case PURIFIED: {
                        canteenItem = TANItems.PURIFIED_WATER_CANTEEN;
                        break;
                    }
                    case DIRTY: {
                        canteenItem = TANItems.DIRTY_WATER_CANTEEN;
                        break;
                    }
                    default: {
                        canteenItem = TANItems.WATER_CANTEEN;
                    }
                }
                return ActionResult.func_233538_a_((Object)this.replaceCanteen(stack, player, new ItemStack((IItemProvider)canteenItem)), (boolean)world.func_201670_d());
            }
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    protected ItemStack replaceCanteen(ItemStack oldStack, PlayerEntity player, ItemStack newStack) {
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        return DrinkHelper.func_242398_a((ItemStack)oldStack, (PlayerEntity)player, (ItemStack)newStack);
    }
}

