/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.block.entity;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import toughasnails.api.crafting.TANRecipeTypes;
import toughasnails.api.tileentity.TANTileEntityTypes;
import toughasnails.block.WaterPurifierBlock;
import toughasnails.container.WaterPurifierContainer;
import toughasnails.crafting.WaterPurifierRecipe;

public class WaterPurifierBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private int filterTimeRemaining;
    private int filterDuration;
    private int purifyProgress;
    private int purifyTotalTime;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return WaterPurifierBlockEntity.this.filterTimeRemaining;
                }
                case 1: {
                    return WaterPurifierBlockEntity.this.filterDuration;
                }
                case 2: {
                    return WaterPurifierBlockEntity.this.purifyProgress;
                }
                case 3: {
                    return WaterPurifierBlockEntity.this.purifyTotalTime;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    WaterPurifierBlockEntity.this.filterTimeRemaining = value;
                    break;
                }
                case 1: {
                    WaterPurifierBlockEntity.this.filterDuration = value;
                    break;
                }
                case 2: {
                    WaterPurifierBlockEntity.this.purifyProgress = value;
                    break;
                }
                case 3: {
                    WaterPurifierBlockEntity.this.purifyTotalTime = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public WaterPurifierBlockEntity(BlockPos pos, BlockState state) {
        super(TANTileEntityTypes.WATER_PURIFIER, pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        this.filterTimeRemaining = nbt.m_128451_("FilterTimeRemaining");
        this.filterDuration = nbt.m_128451_("FilterDuration");
        this.purifyProgress = nbt.m_128451_("PurifyProgress");
        this.purifyTotalTime = nbt.m_128451_("PurifyTotalTime");
    }

    public CompoundTag m_6945_(CompoundTag nbt) {
        super.m_6945_(nbt);
        nbt.m_128405_("FilterTimeRemaining", this.filterTimeRemaining);
        nbt.m_128405_("FilterDuration", this.filterDuration);
        nbt.m_128405_("PurifyProgress", this.purifyProgress);
        nbt.m_128405_("PurifyTotalTime", this.purifyTotalTime);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
        return nbt;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, WaterPurifierBlockEntity blockEntity) {
        boolean previouslyFiltering = blockEntity.currentlyFiltering();
        boolean changed = false;
        if (blockEntity.currentlyFiltering() && blockEntity.purifyProgress > 0) {
            --blockEntity.filterTimeRemaining;
        }
        if (!blockEntity.f_58857_.f_46443_) {
            ItemStack filterStack = (ItemStack)blockEntity.items.get(1);
            if (blockEntity.currentlyFiltering() || !filterStack.m_41619_() && !((ItemStack)blockEntity.items.get(0)).m_41619_()) {
                Recipe irecipe = blockEntity.f_58857_.m_7465_().m_44015_(TANRecipeTypes.WATER_PURIFYING, (Container)blockEntity, blockEntity.f_58857_).orElse(null);
                if (!blockEntity.currentlyFiltering() && blockEntity.canFilter(irecipe)) {
                    blockEntity.filterDuration = blockEntity.filterTimeRemaining = WaterPurifierBlockEntity.getFilterDuration(filterStack);
                    if (blockEntity.currentlyFiltering()) {
                        changed = true;
                        if (filterStack.hasContainerItem()) {
                            blockEntity.items.set(1, (Object)filterStack.getContainerItem());
                        } else if (!filterStack.m_41619_()) {
                            filterStack.m_41774_(1);
                            if (filterStack.m_41619_()) {
                                blockEntity.items.set(1, (Object)filterStack.getContainerItem());
                            }
                        }
                    }
                }
                if (blockEntity.currentlyFiltering() && blockEntity.canFilter(irecipe)) {
                    ++blockEntity.purifyProgress;
                    if (blockEntity.purifyProgress == blockEntity.purifyTotalTime) {
                        blockEntity.purifyProgress = 0;
                        blockEntity.purifyTotalTime = blockEntity.getTotalPurifyTime();
                        blockEntity.filter(irecipe);
                        changed = true;
                    }
                } else {
                    blockEntity.purifyProgress = 0;
                }
            } else if (!blockEntity.currentlyFiltering() && blockEntity.purifyProgress > 0) {
                blockEntity.purifyProgress = Mth.m_14045_((int)(blockEntity.purifyProgress - 2), (int)0, (int)blockEntity.purifyTotalTime);
            }
            if (previouslyFiltering != blockEntity.currentlyFiltering()) {
                changed = true;
                blockEntity.f_58857_.m_7731_(blockEntity.f_58858_, (BlockState)blockEntity.f_58857_.m_8055_(blockEntity.f_58858_).m_61124_((Property)WaterPurifierBlock.PURIFYING, (Comparable)Boolean.valueOf(blockEntity.currentlyFiltering())), 3);
            }
        }
        if (changed) {
            blockEntity.m_6596_();
        }
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new WaterPurifierContainer(id, player, (Container)this, this.dataAccess);
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.toughasnails.water_purifier");
    }

    public int[] m_7071_(Direction side) {
        switch (side) {
            case DOWN: {
                return SLOTS_FOR_DOWN;
            }
            case UP: {
                return SLOTS_FOR_UP;
            }
        }
        return SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return direction != Direction.DOWN || index != 1;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        ItemStack currentStack = (ItemStack)this.items.get(index);
        boolean sameItem = !stack.m_41619_() && stack.m_41656_(currentStack) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)currentStack);
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (index == 0 && !sameItem) {
            this.purifyTotalTime = this.getTotalPurifyTime();
            this.purifyProgress = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public boolean currentlyFiltering() {
        return this.filterTimeRemaining > 0;
    }

    protected boolean canFilter(@Nullable Recipe<?> recipe) {
        if (!((ItemStack)this.items.get(0)).m_41619_() && recipe != null) {
            ItemStack recipeResult = recipe.m_8043_();
            if (recipeResult.m_41619_()) {
                return false;
            }
            ItemStack currentResult = (ItemStack)this.items.get(2);
            if (currentResult.m_41619_()) {
                return true;
            }
            if (!currentResult.m_41656_(recipeResult)) {
                return false;
            }
            if (currentResult.m_41613_() + recipeResult.m_41613_() <= this.m_6893_() && currentResult.m_41613_() + recipeResult.m_41613_() <= currentResult.m_41741_()) {
                return true;
            }
            return currentResult.m_41613_() + recipeResult.m_41613_() <= recipeResult.m_41741_();
        }
        return false;
    }

    protected int getTotalPurifyTime() {
        return this.f_58857_.m_7465_().m_44015_(TANRecipeTypes.WATER_PURIFYING, (Container)this, this.f_58857_).map(WaterPurifierRecipe::getPurifyTime).orElse(200);
    }

    private void filter(@Nullable Recipe<?> recipe) {
        if (recipe != null && this.canFilter(recipe)) {
            ItemStack input = (ItemStack)this.items.get(0);
            ItemStack recipeResult = recipe.m_8043_();
            ItemStack currentResult = (ItemStack)this.items.get(2);
            if (currentResult.m_41619_()) {
                this.items.set(2, (Object)recipeResult.m_41777_());
            } else if (currentResult.m_41720_() == recipeResult.m_41720_()) {
                currentResult.m_41769_(recipeResult.m_41613_());
            }
            input.m_41774_(1);
        }
    }

    public static boolean isFilter(ItemStack stack) {
        return WaterPurifierBlockEntity.getFilterDuration(stack) > 0;
    }

    public static int getFilterDuration(ItemStack filter) {
        if (filter == null || filter.m_41619_()) {
            return 0;
        }
        return (Integer)WaterPurifierBlockEntity.getFilterDurations().getOrDefault((Object)filter.m_41720_(), (Object)0);
    }

    private static ImmutableMap<Item, Integer> getFilterDurations() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)Items.f_42414_, (Object)1200);
        return builder.build();
    }
}

