/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import toughasnails.api.crafting.TANRecipeTypes;
import toughasnails.api.potion.TANPotions;
import toughasnails.crafting.WaterPurifierRecipe;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModCrafting {
    @SubscribeEvent
    public static void registerRecipeSerializers(RegistryEvent.Register<RecipeSerializer<?>> event) {
        ModCrafting.register("water_purifying", new WaterPurifierRecipe.Serializer());
        TANRecipeTypes.WATER_PURIFYING = ModCrafting.register("water_purifying", (RecipeType)new RecipeType<WaterPurifierRecipe>(){

            public String toString() {
                return "water_purifying";
            }
        });
        ModCrafting.addBrewingRecipe(Potions.f_43602_, new ItemStack((ItemLike)Items.f_42452_), TANPotions.ICE_RESISTANCE);
        ModCrafting.addBrewingRecipe(TANPotions.ICE_RESISTANCE, new ItemStack((ItemLike)Items.f_42451_), TANPotions.LONG_ICE_RESISTANCE);
        ModCrafting.addPotionTransforms(TANPotions.ICE_RESISTANCE);
        ModCrafting.addPotionTransforms(TANPotions.LONG_ICE_RESISTANCE);
    }

    public static void register(String name, RecipeSerializer serializer) {
        serializer.setRegistryName(new ResourceLocation("toughasnails", name));
        ForgeRegistries.RECIPE_SERIALIZERS.register((IForgeRegistryEntry)serializer);
    }

    public static <T extends Recipe<?>> RecipeType<T> register(String name, RecipeType type) {
        return (RecipeType)Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)new ResourceLocation("toughasnails", name), (Object)type);
    }

    private static void addBrewingRecipe(Potion input, ItemStack ingredient, Potion output) {
        ModCrafting.addBrewingRecipe(new ItemStack((ItemLike)Items.f_42589_), input, ingredient, new ItemStack((ItemLike)Items.f_42589_), output);
        ModCrafting.addBrewingRecipe(new ItemStack((ItemLike)Items.f_42736_), input, ingredient, new ItemStack((ItemLike)Items.f_42736_), output);
        ModCrafting.addBrewingRecipe(new ItemStack((ItemLike)Items.f_42739_), input, ingredient, new ItemStack((ItemLike)Items.f_42739_), output);
    }

    private static void addPotionTransforms(Potion potion) {
        ModCrafting.addBrewingRecipe(new ItemStack((ItemLike)Items.f_42589_), potion, new ItemStack((ItemLike)Items.f_42403_), new ItemStack((ItemLike)Items.f_42736_), potion);
        ModCrafting.addBrewingRecipe(new ItemStack((ItemLike)Items.f_42739_), potion, new ItemStack((ItemLike)Items.f_42403_), new ItemStack((ItemLike)Items.f_42736_), potion);
        ModCrafting.addBrewingRecipe(new ItemStack((ItemLike)Items.f_42589_), potion, new ItemStack((ItemLike)Items.f_42735_), new ItemStack((ItemLike)Items.f_42739_), potion);
        ModCrafting.addBrewingRecipe(new ItemStack((ItemLike)Items.f_42736_), potion, new ItemStack((ItemLike)Items.f_42735_), new ItemStack((ItemLike)Items.f_42739_), potion);
    }

    private static void addBrewingRecipe(ItemStack inBottle, Potion inPotion, ItemStack ingredient, ItemStack outBottle, Potion outPotion) {
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)inBottle, (Potion)inPotion)}), (Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{ingredient}), (ItemStack)PotionUtils.m_43549_((ItemStack)outBottle, (Potion)outPotion));
    }
}

