/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.config.ThirstConfig;

public class MessageDrinkInWorld {
    public BlockPos pos;

    public MessageDrinkInWorld(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(MessageDrinkInWorld packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
    }

    public static MessageDrinkInWorld decode(FriendlyByteBuf buf) {
        return new MessageDrinkInWorld(buf.m_130135_());
    }

    public static class Handler {
        public static void handle(MessageDrinkInWorld packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                Level world = player.f_19853_;
                IThirst thirst = ThirstHelper.getThirst((Player)player);
                if (world.m_7966_((Player)player, packet.pos) && world.m_6425_(packet.pos).m_76153_((Tag)FluidTags.f_13131_)) {
                    thirst.addThirst((Integer)ThirstConfig.handDrinkingThirst.get());
                    thirst.addHydration(((Double)ThirstConfig.handDrinkingHydration.get()).floatValue());
                    ResourceKey biome = player.f_19853_.m_45837_(packet.pos).orElse(Biomes.f_48202_);
                    if (player.f_19853_.f_46441_.nextFloat() < ThirstConfig.getBiomeWaterType((ResourceKey<Biome>)biome).getPoisonChance()) {
                        player.m_7292_(new MobEffectInstance(TANEffects.THIRST, 600));
                    }
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

