/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import toughasnails.api.capability.TANCapabilities;
import toughasnails.api.damagesource.TANDamageSources;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.temperature.IPlayerTemperatureModifier;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.config.ServerConfig;
import toughasnails.config.TemperatureConfig;
import toughasnails.network.MessageUpdateTemperature;
import toughasnails.network.PacketHandler;
import toughasnails.temperature.TemperatureCapabilityProvider;
import toughasnails.temperature.TemperatureData;
import toughasnails.temperature.TemperatureHelperImpl;

public class TemperatureHandler {
    private static final UUID SPEED_MODIFIER_HYPERTHERMIA_UUID = UUID.fromString("30b6ca4e-c6df-4532-80db-1d024765b56b");

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("toughasnails", "temperature"), (ICapabilityProvider)new TemperatureCapabilityProvider(TANCapabilities.TEMPERATURE, new TemperatureData()));
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer().f_19853_.m_5776_()) {
            return;
        }
        TemperatureHandler.syncTemperature((ServerPlayer)event.getPlayer());
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.getPlayer().f_19853_.m_5776_()) {
            return;
        }
        TemperatureHandler.syncTemperature((ServerPlayer)event.getPlayer());
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!((Boolean)ServerConfig.enableTemperature.get()).booleanValue() || event.player.f_19853_.m_5776_()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        ITemperature data = TemperatureHelper.getTemperatureData((Player)player);
        TemperatureLevel newLevel = TemperatureHelper.getTemperatureAtPos((Level)player.m_9236_(), player.m_142538_());
        for (IPlayerTemperatureModifier modifier : TemperatureHelperImpl.playerModifiers) {
            newLevel = modifier.modify((Player)player, newLevel);
        }
        newLevel = TemperatureHelperImpl.armorModifier((Player)player, newLevel);
        data.setLevel(newLevel);
        data.setExtremityDelayTicks(Math.max(0, data.getExtremityDelayTicks() - 1));
        if (data.getLastLevel() != data.getLevel() && (data.getLevel() == TemperatureLevel.ICY || data.getLevel() == TemperatureLevel.HOT)) {
            data.setExtremityDelayTicks((Integer)TemperatureConfig.extremityDamageDelay.get());
        }
        int hyperthermicTicks = data.getHyperthermiaTicks();
        int ticksToHyperthermia = TemperatureHelper.getTicksRequiredForHyperthermia();
        if (!player.m_7500_() && !player.m_5833_()) {
            int ticksToFreeze;
            int frozenTicks;
            if (!player.m_21023_(TANEffects.ICE_RESISTANCE) && data.getLevel() == TemperatureLevel.ICY && data.getExtremityDelayTicks() == 0 && (frozenTicks = player.m_146888_()) < (ticksToFreeze = player.m_146891_() + 2)) {
                player.m_146917_(Math.min(ticksToFreeze, player.m_146888_() + 2));
            }
            if (!player.m_21023_(MobEffects.f_19607_) && data.getLevel() == TemperatureLevel.HOT && data.getExtremityDelayTicks() == 0) {
                data.setHyperthermiaTicks(Math.min(ticksToHyperthermia, hyperthermicTicks + 1));
                if (player.m_146888_() > 0) {
                    player.m_146917_(Math.max(0, player.m_146888_() - 2));
                }
            } else {
                data.setHyperthermiaTicks(Math.max(0, hyperthermicTicks - 2));
            }
        } else if (data.getHyperthermiaTicks() > 0) {
            data.setHyperthermiaTicks(Math.max(0, hyperthermicTicks - 2));
        }
        if (player.m_21023_(TANEffects.ICE_RESISTANCE) && player.m_146888_() > 0) {
            player.m_146917_(0);
        }
        if (data.getLastLevel() != data.getLevel() || data.getLastHyperthermiaTicks() != data.getHyperthermiaTicks()) {
            TemperatureHandler.syncTemperature(player);
        }
        TemperatureHandler.removeHeatExhaustion(player);
        this.tryAddHeatExhaustion(player);
        if (player.f_19797_ % 40 == 0 && TemperatureHelper.isFullyHyperthermic((Player)player)) {
            player.m_6469_(TANDamageSources.HYPERTHERMIA, 1.0f);
        }
    }

    private static void syncTemperature(ServerPlayer player) {
        ITemperature temperature = TemperatureHelper.getTemperatureData((Player)player);
        temperature.setLastLevel(temperature.getLevel());
        temperature.setLastHyperthermiaTicks(temperature.getHyperthermiaTicks());
        PacketHandler.HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageUpdateTemperature(temperature.getLevel(), temperature.getHyperthermiaTicks()));
    }

    private static void removeHeatExhaustion(ServerPlayer player) {
        AttributeInstance attribute = player.m_21051_(Attributes.f_22279_);
        if (attribute != null && attribute.m_22111_(SPEED_MODIFIER_HYPERTHERMIA_UUID) != null) {
            attribute.m_22120_(SPEED_MODIFIER_HYPERTHERMIA_UUID);
        }
    }

    protected void tryAddHeatExhaustion(ServerPlayer player) {
        int ticks;
        if (!player.f_19853_.m_8055_(player.m_20097_()).m_60795_() && (ticks = TemperatureHelper.getTicksHyperthermic((Player)player)) > 0) {
            AttributeInstance attributeinstance = player.m_21051_(Attributes.f_22279_);
            if (attributeinstance == null) {
                return;
            }
            float f = -0.05f * TemperatureHelper.getPercentHyperthermic((Player)player);
            attributeinstance.m_22118_(new AttributeModifier(SPEED_MODIFIER_HYPERTHERMIA_UUID, "Hyperthermia slow", (double)f, AttributeModifier.Operation.ADDITION));
        }
    }
}

