/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import toughasnails.api.capability.TANCapabilities;
import toughasnails.api.enchantment.TANEnchantments;
import toughasnails.api.temperature.IPlayerTemperatureModifier;
import toughasnails.api.temperature.IPositionalTemperatureModifier;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.config.ServerConfig;
import toughasnails.config.TemperatureConfig;
import toughasnails.init.ModTags;

public class TemperatureHelperImpl
implements TemperatureHelper.Impl.ITemperatureHelper {
    protected static List<IPositionalTemperatureModifier> positionalModifiers = Lists.newArrayList((Object[])new IPositionalTemperatureModifier[]{TemperatureHelperImpl::altitudeModifier, TemperatureHelperImpl::nightModifier});
    protected static List<IPlayerTemperatureModifier> playerModifiers = Lists.newArrayList((Object[])new IPlayerTemperatureModifier[]{TemperatureHelperImpl::immersionModifier});
    private static ITemperature lastTemperature;
    private static final int PROXIMITY_RADIUS = 7;

    @Override
    public TemperatureLevel getTemperatureAtPos(Level level, BlockPos pos) {
        Biome biome = level.m_46857_(pos);
        TemperatureLevel temperature = TemperatureHelperImpl.getBiomeTemperatureLevel(biome, pos);
        for (IPositionalTemperatureModifier modifier : positionalModifiers) {
            temperature = modifier.modify(level, pos, temperature);
        }
        return TemperatureHelperImpl.proximityModifier(level, pos, temperature);
    }

    @Override
    public ITemperature getPlayerTemperature(Player player) {
        ITemperature temperature;
        lastTemperature = temperature = (ITemperature)player.getCapability(TANCapabilities.TEMPERATURE).orElse((Object)lastTemperature);
        return temperature;
    }

    @Override
    public boolean isTemperatureEnabled() {
        return (Boolean)ServerConfig.enableTemperature.get();
    }

    @Override
    public void setTicksHyperthermic(Player player, int ticks) {
        this.getPlayerTemperature(player).setHyperthermiaTicks(ticks);
    }

    @Override
    public float getPercentHyperthermic(Player player) {
        int i = this.getTicksRequiredForHyperthermia();
        return (float)Math.min(this.getTicksHyperthermic(player), i) / (float)i;
    }

    @Override
    public boolean isFullyHyperthermic(Player player) {
        return this.getTicksHyperthermic(player) >= this.getTicksRequiredForHyperthermia();
    }

    @Override
    public int getTicksRequiredForHyperthermia() {
        return 140;
    }

    @Override
    public int getTicksHyperthermic(Player player) {
        return this.getPlayerTemperature(player).getHyperthermiaTicks();
    }

    @Override
    public void registerPlayerTemperatureModifier(IPlayerTemperatureModifier modifier) {
        playerModifiers.add(modifier);
    }

    @Override
    public void registerPositionalTemperatureModifier(IPositionalTemperatureModifier modifier) {
        positionalModifiers.add(modifier);
    }

    private static TemperatureLevel getBiomeTemperatureLevel(Biome biome, BlockPos pos) {
        float biomeTemperature = biome.m_47554_();
        if (pos.m_123342_() > (Integer)TemperatureConfig.environmentalModifierAltitude.get()) {
            if (biomeTemperature < 0.15f) {
                return TemperatureLevel.ICY;
            }
            if (biomeTemperature >= 0.15f && biomeTemperature < 0.45f) {
                return TemperatureLevel.COLD;
            }
            if (biomeTemperature >= 0.45f && biomeTemperature < 0.75f) {
                return TemperatureLevel.NEUTRAL;
            }
            if (biomeTemperature >= 0.75f && biomeTemperature < 0.9f) {
                return TemperatureLevel.WARM;
            }
            if (biomeTemperature >= 0.9f) {
                return TemperatureLevel.HOT;
            }
        }
        return TemperatureLevel.NEUTRAL;
    }

    private static TemperatureLevel altitudeModifier(Level level, BlockPos pos, TemperatureLevel current) {
        if (pos.m_123342_() > (Integer)TemperatureConfig.temperatureDropAltitude.get()) {
            current = current.decrement(1);
        } else if (pos.m_123342_() < (Integer)TemperatureConfig.temperatureRiseAltitude.get()) {
            current = current.increment(1);
        }
        return current;
    }

    private static TemperatureLevel nightModifier(Level level, BlockPos pos, TemperatureLevel current) {
        if (level.m_46462_() && pos.m_123342_() > (Integer)TemperatureConfig.environmentalModifierAltitude.get()) {
            if (current == TemperatureLevel.HOT) {
                current = current.increment((Integer)TemperatureConfig.nightHotTemperatureChange.get());
            } else if (current != TemperatureLevel.NEUTRAL) {
                current = current.increment((Integer)TemperatureConfig.nightTemperatureChange.get());
            }
        }
        return current;
    }

    private static TemperatureLevel proximityModifier(Level level, BlockPos pos, TemperatureLevel current) {
        int numCloseCoolSources = 0;
        int numFarCoolSources = 0;
        int numCloseHeatSources = 0;
        int numFarHeatSources = 0;
        for (int x = -7; x <= 7; ++x) {
            for (int y = -7; y <= 7; ++y) {
                for (int z = -7; z <= 7; ++z) {
                    boolean isClose;
                    BlockPos newPos = pos.m_142082_(x, y, z);
                    BlockState state = level.m_8055_(newPos);
                    boolean bl = isClose = newPos.m_123331_((Vec3i)pos) <= Math.pow(((Integer)TemperatureConfig.nearBlockRange.get()).intValue(), 2.0) + 1.0;
                    if (state.m_60620_(ModTags.Blocks.HEATING_BLOCKS)) {
                        if (isClose) {
                            ++numCloseHeatSources;
                            continue;
                        }
                        ++numFarHeatSources;
                        continue;
                    }
                    if (!state.m_60620_(ModTags.Blocks.COOLING_BLOCKS)) continue;
                    if (isClose) {
                        ++numCloseCoolSources;
                        continue;
                    }
                    ++numFarCoolSources;
                }
            }
        }
        int closeSum = numCloseHeatSources - numCloseCoolSources;
        int farSum = numFarHeatSources - numFarCoolSources;
        if (closeSum > 0) {
            current = current.increment(2);
        } else if (closeSum < 0) {
            current = current.decrement(2);
        } else if (farSum > 0) {
            current = current.increment(1);
        } else if (farSum < 0) {
            current = current.decrement(1);
        }
        return current;
    }

    private static TemperatureLevel immersionModifier(Player player, TemperatureLevel current) {
        if (player.m_6060_()) {
            current = current.increment((Integer)TemperatureConfig.onFireTemperatureChange.get());
        }
        if (player.f_146808_) {
            current = current.increment((Integer)TemperatureConfig.powderSnowTemperatureChange.get());
        }
        if (player.m_20070_()) {
            current = current.increment((Integer)TemperatureConfig.wetTemperatureChange.get());
        }
        return current;
    }

    protected static TemperatureLevel armorModifier(Player player, TemperatureLevel current) {
        AtomicInteger coolingPieces = new AtomicInteger();
        AtomicInteger heatingPieces = new AtomicInteger();
        player.m_6168_().forEach(stack -> {
            if (stack.m_150922_(ModTags.Items.COOLING_ARMOR)) {
                coolingPieces.getAndIncrement();
            }
            if (stack.m_150922_(ModTags.Items.HEATING_ARMOR)) {
                heatingPieces.getAndIncrement();
            }
        });
        TemperatureLevel armorAdjTemp = current.increment(heatingPieces.get() / 2 - coolingPieces.get() / 2);
        if (armorAdjTemp == TemperatureLevel.HOT && current != TemperatureLevel.HOT) {
            current = armorAdjTemp.decrement(1);
        } else if (armorAdjTemp == TemperatureLevel.ICY && current != TemperatureLevel.ICY) {
            current = armorAdjTemp.increment(1);
        }
        if (EnchantmentHelper.m_44836_((Enchantment)TANEnchantments.THERMAL_TUNING, (LivingEntity)player) > 0) {
            current = TemperatureLevel.NEUTRAL;
        }
        return current;
    }
}

