/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fmlclient.gui.GuiUtils;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.config.ServerConfig;

@OnlyIn(value=Dist.CLIENT)
public class TemperatureOverlayHandler {
    private static final Random RANDOM = new Random();
    public static final ResourceLocation OVERLAY = new ResourceLocation("toughasnails:textures/gui/icons.png");
    private static final ResourceLocation HYPERTHERMIA_OUTLINE_LOCATION = new ResourceLocation("toughasnails", "textures/misc/hyperthermia_outline.png");
    public static final IIngameOverlay TEMPERATURE_LEVEL_ELEMENT = OverlayRegistry.registerOverlayTop((String)"Temperature Level", (gui, mStack, partialTicks, screenWidth, screenHeight) -> {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!minecraft.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            gui.setupOverlayRenderState(true, false);
            TemperatureOverlayHandler.renderTemperature(gui, mStack, partialTicks, screenWidth, screenHeight);
        }
    });
    public static final IIngameOverlay HYPERTHERMIA_ELEMENT = OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.FROSTBITE_ELEMENT, (String)"Hyperthermia", (gui, mStack, partialTicks, screenWidth, screenHeight) -> {
        gui.setupOverlayRenderState(true, false);
        TemperatureOverlayHandler.renderHyperthermia(gui, mStack);
    });
    private static long updateCounter;
    private static long flashCounter;
    private static TemperatureLevel prevTemperatureLevel;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (((Boolean)ServerConfig.enableTemperature.get()).booleanValue() && event.phase == TickEvent.Phase.END && !minecraft.m_91104_()) {
            ++updateCounter;
        }
    }

    private static void renderTemperature(ForgeIngameGui gui, PoseStack mStack, float partialTicks, int width, int height) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!((Boolean)ServerConfig.enableTemperature.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = minecraft.f_91074_;
        TemperatureLevel temperature = TemperatureHelper.getTemperatureForPlayer((Player)player);
        RANDOM.setSeed(updateCounter * 312871L);
        if (minecraft.f_91072_.m_105295_().m_46409_()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)OVERLAY);
            TemperatureOverlayHandler.drawTemperature(mStack, width, height, temperature);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        }
    }

    private static void renderHyperthermia(ForgeIngameGui gui, PoseStack pStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (TemperatureHelper.getTicksHyperthermic((Player)player) > 0) {
            gui.m_168708_(HYPERTHERMIA_OUTLINE_LOCATION, TemperatureHelper.getPercentHyperthermic((Player)player));
        }
    }

    private static void drawTemperature(PoseStack matrixStack, int width, int height, TemperatureLevel temperature) {
        int left = width / 2 - 8;
        int top = height - 52;
        if (prevTemperatureLevel == null) {
            prevTemperatureLevel = temperature;
        }
        if (prevTemperatureLevel != temperature) {
            flashCounter = updateCounter + 3L;
        }
        prevTemperatureLevel = temperature;
        if ((temperature == TemperatureLevel.ICY || temperature == TemperatureLevel.HOT) && updateCounter % 1L == 0L) {
            top += (int)((double)(RANDOM.nextInt(3) - 1) * Math.min(3.0, 1.0));
            left += (int)((double)(RANDOM.nextInt(3) - 1) * Math.min(1.5, 1.0));
        }
        int iconIndex = temperature.ordinal() * 16;
        int v = 0;
        if (flashCounter > updateCounter) {
            v += 16;
        }
        GuiUtils.drawTexturedModalRect((PoseStack)matrixStack, (int)left, (int)top, (int)iconIndex, (int)v, (int)16, (int)16, (float)9.0f);
    }
}

