/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.thirst;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fmlclient.gui.GuiUtils;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.config.ClientConfig;
import toughasnails.config.ServerConfig;

@OnlyIn(value=Dist.CLIENT)
public class ThirstOverlayHandler {
    private static final Random RANDOM = new Random();
    public static final ResourceLocation OVERLAY = new ResourceLocation("toughasnails:textures/gui/icons.png");
    public static final IIngameOverlay THIRST_LEVEL_ELEMENT = OverlayRegistry.registerOverlayBelow((IIngameOverlay)ForgeIngameGui.AIR_LEVEL_ELEMENT, (String)"Thirst Level", (gui, mStack, partialTicks, screenWidth, screenHeight) -> {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!minecraft.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            gui.setupOverlayRenderState(true, false);
            ThirstOverlayHandler.renderThirst(gui, mStack, partialTicks, screenWidth, screenHeight);
        }
    });
    private static int updateCounter;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (((Boolean)ServerConfig.enableThirst.get()).booleanValue() && event.phase == TickEvent.Phase.END && !minecraft.m_91104_()) {
            ++updateCounter;
        }
    }

    private static void renderThirst(ForgeIngameGui gui, PoseStack mStack, float partialTicks, int width, int height) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!((Boolean)ServerConfig.enableThirst.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = minecraft.f_91074_;
        IThirst thirst = ThirstHelper.getThirst((Player)player);
        int thirstLevel = thirst.getThirst();
        float thirstHydrationLevel = thirst.getHydration();
        RANDOM.setSeed((long)updateCounter * 312871L);
        if (minecraft.f_91072_.m_105295_().m_46409_()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)OVERLAY);
            ThirstOverlayHandler.drawThirst(mStack, width, height, thirstLevel, thirstHydrationLevel);
            gui.right_height += 10;
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        }
    }

    private static void drawThirst(PoseStack matrixStack, int width, int height, int thirstLevel, float thirstHydrationLevel) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        int left = width / 2 + 91 + (Integer)ClientConfig.thirstLeftOffset.get();
        int top = height - ((ForgeIngameGui)Minecraft.m_91087_().f_91065_).right_height + (Integer)ClientConfig.thirstTopOffset.get();
        for (int i = 0; i < 10; ++i) {
            int dropletHalf = i * 2 + 1;
            int iconIndex = 0;
            int startX = left - i * 8 - 9;
            int startY = top;
            int backgroundU = 0;
            if (player.m_21023_(TANEffects.THIRST)) {
                iconIndex += 4;
                backgroundU += 117;
            }
            if (thirstHydrationLevel <= 0.0f && updateCounter % (thirstLevel * 3 + 1) == 0) {
                startY = top + (RANDOM.nextInt(3) - 1);
            }
            GuiUtils.drawTexturedModalRect((PoseStack)matrixStack, (int)startX, (int)startY, (int)backgroundU, (int)32, (int)9, (int)9, (float)9.0f);
            if (thirstLevel > dropletHalf) {
                GuiUtils.drawTexturedModalRect((PoseStack)matrixStack, (int)startX, (int)startY, (int)((iconIndex + 4) * 9), (int)32, (int)9, (int)9, (float)9.0f);
                continue;
            }
            if (thirstLevel != dropletHalf) continue;
            GuiUtils.drawTexturedModalRect((PoseStack)matrixStack, (int)startX, (int)startY, (int)((iconIndex + 5) * 9), (int)32, (int)9, (int)9, (float)9.0f);
        }
    }
}

