/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.EnumDifficulty;

public class HealthHelper {
    public static final UUID STARTING_HEALTH_MODIFIER_ID = UUID.fromString("050F240E-868F-4164-A67E-374084DACA71");
    public static final UUID LIFEBLOOD_HEALTH_MODIFIER_ID = UUID.fromString("B04DB09D-ED8A-4B82-B1EF-ADB425174925");
    public static IHeartAmountProvider heartProvider;

    public static int getActiveHearts(EntityPlayer player) {
        return Math.min((int)(player.func_110138_aP() / 2.0f), 10);
    }

    public static int getInactiveHearts(EntityPlayer player) {
        return Math.max(10 - (int)(player.func_110138_aP() / 2.0f), 0);
    }

    public static int getLifebloodHearts(EntityPlayer player) {
        IAttributeInstance maxHealthInstance = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
        AttributeModifier modifier = maxHealthInstance.func_111127_a(LIFEBLOOD_HEALTH_MODIFIER_ID);
        if (modifier != null) {
            return (int)(modifier.func_111164_d() / 2.0);
        }
        return 0;
    }

    public static boolean addActiveHearts(EntityPlayer player, int hearts) {
        double existingHearts;
        IAttributeInstance maxHealthInstance = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
        AttributeModifier modifier = maxHealthInstance.func_111127_a(LIFEBLOOD_HEALTH_MODIFIER_ID);
        float newHealth = player.func_110138_aP() + (float)(hearts * 2);
        double d = existingHearts = modifier != null ? modifier.func_111164_d() : 0.0;
        if (newHealth <= (float)heartProvider.getMaxHearts() * 2.0f && newHealth > 0.0f) {
            HashMultimap multimap = HashMultimap.create();
            modifier = new AttributeModifier(LIFEBLOOD_HEALTH_MODIFIER_ID, "Lifeblood Health Modifier", existingHearts + (double)(hearts * 2), 0);
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)modifier);
            player.func_110140_aT().func_111147_b((Multimap)multimap);
            return true;
        }
        return false;
    }

    public static int getStartingHearts(EnumDifficulty difficulty) {
        return heartProvider.getStartingHearts(difficulty);
    }

    public static interface IHeartAmountProvider {
        public int getMaxHearts();

        public int getStartingHearts(EnumDifficulty var1);
    }
}

