/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.api.season;

import net.minecraft.world.World;
import toughasnails.api.config.SeasonsOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.season.ISeasonData;
import toughasnails.api.season.Season;

public class SeasonHelper {
    public static ISeasonDataProvider dataProvider;

    public static ISeasonData getSeasonData(World world) {
        ISeasonData data = !world.field_72995_K ? dataProvider.getServerSeasonData(world) : dataProvider.getClientSeasonData();
        return data;
    }

    public static boolean canSnowAtTempInSeason(Season season, float temperature) {
        return temperature < 0.15f || season == Season.WINTER && temperature <= 0.7f && SyncedConfig.getBooleanValue(SeasonsOption.ENABLE_SEASONS);
    }

    public static interface ISeasonDataProvider {
        public ISeasonData getServerSeasonData(World var1);

        public ISeasonData getClientSeasonData();
    }
}

