/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.asm.transformer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import toughasnails.asm.ASMHelper;
import toughasnails.asm.ObfHelper;

public class CropDecayTransformer
implements IClassTransformer {
    private static final String[] UPDATE_TICK_NAMES = new String[]{"updateTick", "func_180650_b", "b"};

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.block.BlockCrops") || transformedName.equals("net.minecraft.block.BlockStem")) {
            return this.transformToDecay(basicClass, !transformedName.equals(name), transformedName, true);
        }
        ClassReader classReader = new ClassReader(basicClass);
        InterfaceCheckVisitor visitor = new InterfaceCheckVisitor("toughasnails/api/season/IDecayableCrop");
        classReader.accept((ClassVisitor)visitor, 1);
        if (visitor.isInterfaceFound) {
            return this.transformToDecay(basicClass, !transformedName.equals(name), transformedName, false);
        }
        return basicClass;
    }

    private byte[] transformToDecay(byte[] bytes, boolean obfuscatedClass, String name, boolean isVanilla) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        if (isVanilla) {
            classNode.interfaces.add("toughasnails/api/season/IDecayableCrop");
        }
        ArrayList successfulTransformations = Lists.newArrayList();
        for (MethodNode methodNode : classNode.methods) {
            if (!ASMHelper.methodEquals(methodNode, UPDATE_TICK_NAMES, ObfHelper.createMethodDescriptor(obfuscatedClass, "V", "net/minecraft/world/World", "net/minecraft/util/math/BlockPos", "net/minecraft/block/state/IBlockState", "java/util/Random"))) continue;
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 2));
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, "toughasnails/season/SeasonASMHelper", "onUpdateTick", ObfHelper.createMethodDescriptor(obfuscatedClass, "V", "net/minecraft/block/Block", "net/minecraft/world/World", "net/minecraft/util/math/BlockPos"), false));
            methodNode.instructions.insertBefore(methodNode.instructions.get(methodNode.instructions.indexOf(methodNode.instructions.getLast()) - 1), insnList);
            successfulTransformations.add(methodNode.name + " " + methodNode.desc);
        }
        if (isVanilla) {
            if (successfulTransformations.size() != 1) {
                throw new RuntimeException("An error occurred transforming " + name + ". Applied transformations: " + ((Object)successfulTransformations).toString());
            }
            MethodNode decayMethod = new MethodNode(1, "shouldDecay", "()Z", null, null);
            InsnList decayInsns = new InsnList();
            decayInsns.add((AbstractInsnNode)new LdcInsnNode((Object)new Integer(1)));
            decayInsns.add((AbstractInsnNode)new InsnNode(172));
            decayMethod.instructions.add(decayInsns);
            classNode.methods.add(decayMethod);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        bytes = writer.toByteArray();
        return bytes;
    }

    public static class InterfaceCheckVisitor
    extends ClassVisitor {
        public boolean isInterfaceFound = false;
        public String searchInterface;

        public InterfaceCheckVisitor(String searchInterface) {
            super(327680);
            this.searchInterface = searchInterface;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            for (String iface : interfaces) {
                if (!iface.equals(this.searchInterface)) continue;
                this.isInterfaceFound = true;
                return;
            }
        }
    }
}

