/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toughasnails.api.ITANBlock;
import toughasnails.core.ToughAsNails;
import toughasnails.item.ItemTANBlock;
import toughasnails.particle.TANParticleTypes;
import toughasnails.tileentity.TileEntityTemperatureSpread;

public class BlockTANTemperatureCoil
extends BlockContainer
implements ITANBlock {
    public static final PropertyEnum<CoilType> VARIANT = PropertyEnum.func_177709_a((String)"variant", CoilType.class);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    protected static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemTANBlock.class;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{VARIANT};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((CoilType)((Object)state.func_177229_b(VARIANT))).func_176610_l() + "_coil";
    }

    public BlockTANTemperatureCoil() {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)CoilType.COOLING)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)CoilType.values()[meta & 1])).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            double d2;
            double d1;
            double d0;
            if (state.func_177229_b(VARIANT) == CoilType.HEATING) {
                d0 = (float)pos.func_177958_n() + 0.4f + rand.nextFloat() * 0.2f;
                d1 = (float)pos.func_177956_o() + 0.7f + rand.nextFloat() * 0.3f;
                d2 = (float)pos.func_177952_p() + 0.4f + rand.nextFloat() * 0.2f;
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            }
            if (state.func_177229_b(VARIANT) == CoilType.COOLING) {
                d0 = (float)pos.func_177958_n() + 0.4f + rand.nextFloat() * 0.2f;
                d1 = (float)pos.func_177956_o() + 0.7f + rand.nextFloat() * 0.3f;
                d2 = (float)pos.func_177952_p() + 0.4f + rand.nextFloat() * 0.2f;
                ToughAsNails.proxy.spawnParticle(TANParticleTypes.SNOWFLAKE, world, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((CoilType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public int func_176201_c(IBlockState state) {
        int baseMeta = ((CoilType)((Object)state.func_177229_b(VARIANT))).ordinal();
        return baseMeta | ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 8 : 0);
    }

    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 7 : 0;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        IBlockState state = this.func_176203_a(meta);
        switch ((CoilType)((Object)state.func_177229_b(VARIANT))) {
            case COOLING: {
                return new TileEntityTemperatureSpread(-10);
            }
            case HEATING: {
                return new TileEntityTemperatureSpread(10);
            }
        }
        return null;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        this.updatePowered(world, pos, state);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.updatePowered(world, pos, state);
    }

    private void updatePowered(World world, BlockPos pos, IBlockState state) {
        boolean powered = world.func_175640_z(pos) || world.func_175640_z(pos.func_177984_a());
        TileEntity te = world.func_175625_s(pos);
        if (!world.field_72995_K && te != null && powered != (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)POWERED)) {
            TileEntityTemperatureSpread tempFill = (TileEntityTemperatureSpread)te;
            if (powered) {
                tempFill.fill();
                world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
            } else {
                tempFill.reset();
                world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, POWERED});
    }

    public static enum CoilType implements IStringSerializable
    {
        COOLING,
        HEATING;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

