/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.config;

import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import toughasnails.api.config.ISyncedOption;
import toughasnails.api.config.SyncedConfig;

public abstract class ConfigHandler {
    public Configuration config;

    protected ConfigHandler(File configFile) {
        this.config = new Configuration(configFile);
        this.loadConfiguration();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected abstract void loadConfiguration();

    protected <T> void addSyncedValue(ISyncedOption option, T defaultValue, String category, String comment, T ... args) {
        String value = "";
        if (defaultValue instanceof String) {
            value = this.config.getString(option.getOptionName(), category, defaultValue.toString(), comment);
        } else if (defaultValue instanceof Integer) {
            value = "" + this.config.getInt(option.getOptionName(), category, ((Integer)defaultValue).intValue(), ((Integer)args[0]).intValue(), ((Integer)args[1]).intValue(), comment);
        } else if (defaultValue instanceof Boolean) {
            value = "" + this.config.getBoolean(option.getOptionName(), category, ((Boolean)defaultValue).booleanValue(), comment);
        } else if (defaultValue instanceof Float) {
            value = "" + this.config.getFloat(option.getOptionName(), category, ((Float)defaultValue).floatValue(), ((Float)args[0]).floatValue(), ((Float)args[1]).floatValue(), comment);
        }
        SyncedConfig.addOption(option, value);
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("toughasnails")) {
            this.loadConfiguration();
        }
    }
}

