/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.config;

import java.io.File;
import toughasnails.api.config.GameplayOption;
import toughasnails.config.ConfigHandler;
import toughasnails.core.ToughAsNails;

public class GameplayConfig
extends ConfigHandler {
    public static final String SURVIVAL_SETTINGS = "Survival Settings";
    public static final String STARTING_HEALTH = "Staring health";
    public int easyStartingHearts;
    public int normalStartingHearts;
    public int hardStartingHearts;
    public int maxHearts;

    public GameplayConfig(File configFile) {
        super(configFile);
    }

    @Override
    protected void loadConfiguration() {
        try {
            this.addSyncedValue(GameplayOption.ENABLE_LOWERED_STARTING_HEALTH, true, SURVIVAL_SETTINGS, "Players begin with a lowered maximum health.", new Boolean[0]);
            this.addSyncedValue(GameplayOption.ENABLE_THIRST, true, SURVIVAL_SETTINGS, "Players are affected by thirst", new Boolean[0]);
            this.easyStartingHearts = this.config.getInt("Easy starting hearts", STARTING_HEALTH, 7, 1, 10, "Amount of hearts players will start with on easy");
            this.normalStartingHearts = this.config.getInt("Normal starting hearts", STARTING_HEALTH, 5, 1, 10, "Amount of hearts players will start with on normal");
            this.hardStartingHearts = this.config.getInt("Hard starting hearts", STARTING_HEALTH, 3, 1, 10, "Amount of hearts players will start with on hard");
            this.maxHearts = this.config.getInt("Max hearts", SURVIVAL_SETTINGS, 10, 10, 100, "Max amount of hearts players can get");
        }
        catch (Exception e) {
            ToughAsNails.logger.error("Tough As Nails has encountered a problem loading gameplay.cfg", (Throwable)e);
        }
        finally {
            if (this.config.hasChanged()) {
                this.config.save();
            }
        }
    }
}

