/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.config;

import java.io.File;
import toughasnails.api.config.SeasonsOption;
import toughasnails.config.ConfigHandler;
import toughasnails.core.ToughAsNails;

public class SeasonsConfig
extends ConfigHandler {
    public static final String TIME_SETTINGS = "Time Settings";
    public static final String EVENT_SETTINGS = "Event Settings";
    public static final String AESTHETIC_SETTINGS = "Aesthetic Settings";
    public boolean winterCropDeath;
    public boolean changeGrassColour;
    public boolean changeFoliageColour;

    public SeasonsConfig(File configFile) {
        super(configFile);
    }

    @Override
    protected void loadConfiguration() {
        try {
            this.addSyncedValue(SeasonsOption.ENABLE_SEASONS, true, "Toggle", "Seasons progress as days increase", new Boolean[0]);
            this.addSyncedValue(SeasonsOption.DAY_DURATION, 24000, TIME_SETTINGS, "The duration of a Minecraft day in ticks", 20, Integer.MAX_VALUE);
            this.addSyncedValue(SeasonsOption.SUB_SEASON_DURATION, 5, TIME_SETTINGS, "The duration of a sub season in days", 1, Integer.MAX_VALUE);
            this.winterCropDeath = this.config.getBoolean("Enable Winter Crop Death", EVENT_SETTINGS, true, "Kill unheated crops during the winter");
            this.changeGrassColour = this.config.getBoolean("Change Grass Colour Seasonally", AESTHETIC_SETTINGS, true, "Change the grass colour based on the current season");
            this.changeFoliageColour = this.config.getBoolean("Change Foliage Colour Seasonally", AESTHETIC_SETTINGS, true, "Change the foliage colour based on the current season");
        }
        catch (Exception e) {
            ToughAsNails.logger.error("Tough As Nails has encountered a problem loading seasons.cfg", (Throwable)e);
        }
        finally {
            if (this.config.hasChanged()) {
                this.config.save();
            }
        }
    }
}

