/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.config;

import java.io.File;
import toughasnails.api.config.TemperatureOption;
import toughasnails.config.ConfigHandler;
import toughasnails.core.ToughAsNails;

public class TemperatureConfig
extends ConfigHandler {
    public static final String RATE_SETTINGS = "Rate Settings";
    public static final String MODIFIER_SETTINGS = "Modifier Settings";
    public int altitudeModifier;
    public int jelledSlimeArmorModifier;
    public int woolArmorModifier;
    public int maxBiomeTempOffset;
    public int sprintingModifier;
    public int earlySpringModifier;
    public int midSpringModifier;
    public int lateSpringModifier;
    public int earlySummerModifier;
    public int midSummerModifier;
    public int lateSummerModifier;
    public int earlyAutumnModifier;
    public int midAutumnModifier;
    public int lateAutumnModifier;
    public int earlyWinterModifier;
    public int midWinterModifier;
    public int lateWinterModifier;
    public int timeModifier;
    public float timeExtremityMultiplier;
    public int wetModifier;
    public int snowModifier;

    public TemperatureConfig(File configFile) {
        super(configFile);
    }

    @Override
    protected void loadConfiguration() {
        try {
            this.addSyncedValue(TemperatureOption.ENABLE_TEMPERATURE, true, "Toggle", "Players are affected by temperature", new Boolean[0]);
            this.addSyncedValue(TemperatureOption.BASE_TEMPERATURE_CHANGE_TICKS, 400, RATE_SETTINGS, "The maximum number of ticks before the temperature changes", 20, Integer.MAX_VALUE);
            this.addSyncedValue(TemperatureOption.MAX_RATE_MODIFIER, 380, RATE_SETTINGS, "The maximum number of ticks to reduce the base rate by", 20, Integer.MAX_VALUE);
            this.altitudeModifier = this.config.getInt("Altitude Modifier", MODIFIER_SETTINGS, 3, 0, Integer.MAX_VALUE, "The maximum to increase/decrease temperature by depending on the altitude");
            this.jelledSlimeArmorModifier = this.config.getInt("Jelled Slime Armor Modifier", MODIFIER_SETTINGS, -1, Integer.MIN_VALUE, 0, "The amount to decrease the temperature by per unit of jelled slime armor");
            this.woolArmorModifier = this.config.getInt("Wool Armor Modifier", MODIFIER_SETTINGS, 1, 0, Integer.MAX_VALUE, "The amount to increase the temperature by per unit of wool armor");
            this.maxBiomeTempOffset = this.config.getInt("Max Biome Temperature Modifier", MODIFIER_SETTINGS, 10, 0, Integer.MAX_VALUE, "The maximum to increase/decrease temperature by depending on the biome");
            this.sprintingModifier = this.config.getInt("Sprinting Modifier", MODIFIER_SETTINGS, 3, 0, Integer.MAX_VALUE, "The amount to increase the temperature by when sprinting");
            this.earlySpringModifier = this.config.getInt("Early Spring Modifier", MODIFIER_SETTINGS, -5, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.midSpringModifier = this.config.getInt("Mid Spring Modifier", MODIFIER_SETTINGS, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.lateSpringModifier = this.config.getInt("Late Spring Modifier", MODIFIER_SETTINGS, 2, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.earlySummerModifier = this.config.getInt("Early Summer Modifier", MODIFIER_SETTINGS, 4, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.midSummerModifier = this.config.getInt("Mid Summer Modifier", MODIFIER_SETTINGS, 6, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.lateSummerModifier = this.config.getInt("Late Summer Modifier", MODIFIER_SETTINGS, 4, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.earlyAutumnModifier = this.config.getInt("Early Autumn Modifier", MODIFIER_SETTINGS, 2, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.midAutumnModifier = this.config.getInt("Mid Autumn Modifier", MODIFIER_SETTINGS, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.lateAutumnModifier = this.config.getInt("Late Autumn Modifier", MODIFIER_SETTINGS, -3, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.earlyWinterModifier = this.config.getInt("Early Winter Modifier", MODIFIER_SETTINGS, -7, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.midWinterModifier = this.config.getInt("Mid Winter Modifier", MODIFIER_SETTINGS, -15, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.lateWinterModifier = this.config.getInt("Late Winter Modifier", MODIFIER_SETTINGS, -10, Integer.MIN_VALUE, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in this sub season");
            this.timeModifier = this.config.getInt("Time Modifier", MODIFIER_SETTINGS, 9, 0, Integer.MAX_VALUE, "The amount to increase/decrease the temperature by in the middle of the day/night");
            this.timeExtremityMultiplier = this.config.getFloat("Time Extremity Multiplier", MODIFIER_SETTINGS, 1.25f, 0.0f, Float.MAX_VALUE, "The amount to multiply the temperature increment/decrement by in the middle of the day/night based on how extreme the biome temperature is");
            this.wetModifier = this.config.getInt("Wet Modifier", MODIFIER_SETTINGS, -7, Integer.MIN_VALUE, 0, "The amount to decrease the temperature by when wet");
            this.snowModifier = this.config.getInt("Snow Modifier", MODIFIER_SETTINGS, -10, Integer.MIN_VALUE, 0, "The amount to decrease the temperature by when snowing");
        }
        catch (Exception e) {
            ToughAsNails.logger.error("Tough As Nails has encountered a problem loading temperature.cfg", (Throwable)e);
        }
        finally {
            if (this.config.hasChanged()) {
                this.config.save();
            }
        }
    }
}

