/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.core;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import toughasnails.api.ITANBlock;
import toughasnails.core.CommonProxy;
import toughasnails.entities.EntityFreeze;
import toughasnails.entities.RenderFreeze;
import toughasnails.entities.projectile.EntityIceball;
import toughasnails.entities.projectile.RenderIceball;
import toughasnails.particle.EntitySnowflakeFX;
import toughasnails.particle.TANParticleTypes;

public class ClientProxy
extends CommonProxy {
    public static ResourceLocation particleTexturesLocation = new ResourceLocation("toughasnails:textures/particles/particles.png");

    @Override
    public void registerRenderers() {
        ClientProxy.registerEntityRenderer(EntityIceball.class, RenderIceball.class);
        ClientProxy.registerEntityRenderer(EntityFreeze.class, RenderFreeze.class);
    }

    @Override
    public void registerItemVariantModel(Item item, String name, int metadata) {
        if (item != null) {
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("toughasnails:" + name)});
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation("toughasnails:" + name, "inventory"));
        }
    }

    @Override
    public void registerNonRenderingProperties(Block block) {
        ITANBlock bopBlock;
        IProperty[] nonRenderingProperties;
        if (block instanceof ITANBlock && (nonRenderingProperties = (bopBlock = (ITANBlock)block).getNonRenderingProperties()) != null) {
            StateMap custom_mapper = new StateMap.Builder().func_178442_a(nonRenderingProperties).func_178441_a();
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)custom_mapper);
        }
    }

    @Override
    public void registerFluidBlockRendering(Block block, String name) {
        final ModelResourceLocation fluidLocation = new ModelResourceLocation("toughasnails".toLowerCase() + ":fluids", name);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return fluidLocation;
            }
        });
    }

    @Override
    public void spawnParticle(TANParticleTypes type, World parWorld, double x, double y, double z, Object ... info) {
        Minecraft minecraft = Minecraft.func_71410_x();
        EntitySnowflakeFX entityFx = null;
        switch (type) {
            case SNOWFLAKE: {
                entityFx = new EntitySnowflakeFX(parWorld, x, y, z, MathHelper.func_82716_a((Random)parWorld.field_73012_v, (double)-0.03, (double)0.03), -0.02, MathHelper.func_82716_a((Random)parWorld.field_73012_v, (double)-0.03, (double)0.03));
                break;
            }
        }
        if (entityFx != null) {
            minecraft.field_71452_i.func_78873_a(entityFx);
        }
    }

    private static <E extends Entity> void registerEntityRenderer(Class<E> entityClass, Class<? extends Render<E>> renderClass) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, new EntityRenderFactory(renderClass));
    }

    private static class EntityRenderFactory<E extends Entity>
    implements IRenderFactory<E> {
        private Class<? extends Render<E>> renderClass;

        private EntityRenderFactory(Class<? extends Render<E>> renderClass) {
            this.renderClass = renderClass;
        }

        public Render<E> createRenderFor(RenderManager manager) {
            Render<E> renderer = null;
            try {
                renderer = this.renderClass.getConstructor(RenderManager.class).newInstance(manager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return renderer;
        }
    }
}

