/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.handler.health;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toughasnails.api.HealthHelper;
import toughasnails.api.config.GameplayOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.init.ModConfig;

public class MaxHealthHandler
implements HealthHelper.IHeartAmountProvider {
    @SubscribeEvent
    public void onPlayerLogin(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            this.updateStartingHealthModifier(world.func_175659_aa(), player);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        IAttributeInstance oldMaxHealthInstance = event.getOriginal().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
        AttributeModifier modifier = oldMaxHealthInstance.func_111127_a(HealthHelper.LIFEBLOOD_HEALTH_MODIFIER_ID);
        if (SyncedConfig.getBooleanValue(GameplayOption.ENABLE_LOWERED_STARTING_HEALTH) && modifier != null) {
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)modifier);
            event.getEntityPlayer().func_110140_aT().func_111147_b((Multimap)multimap);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        IntegratedServer integratedServer = minecraft.func_71401_C();
        if (SyncedConfig.getBooleanValue(GameplayOption.ENABLE_LOWERED_STARTING_HEALTH) && event.phase == TickEvent.Phase.END && integratedServer != null) {
            boolean gamePaused;
            boolean bl = gamePaused = Minecraft.func_71410_x().func_147114_u() != null && minecraft.func_147113_T();
            if (!gamePaused && minecraft.field_71441_e != null) {
                WorldInfo serverWorldInfo = integratedServer.field_71305_c[0].func_72912_H();
                WorldInfo localWorldInfo = minecraft.field_71441_e.func_72912_H();
                if (localWorldInfo.func_176130_y() != serverWorldInfo.func_176130_y()) {
                    List players = integratedServer.func_184103_al().func_181057_v();
                    for (EntityPlayerMP player : players) {
                        this.updateStartingHealthModifier(localWorldInfo.func_176130_y(), (EntityPlayer)player);
                    }
                }
            }
        }
    }

    private void updateStartingHealthModifier(EnumDifficulty difficulty, EntityPlayer player) {
        double extraHealth;
        double lifebloodHearts;
        IAttributeInstance maxHealthInstance = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
        AttributeModifier modifier = maxHealthInstance.func_111127_a(HealthHelper.STARTING_HEALTH_MODIFIER_ID);
        if (!SyncedConfig.getBooleanValue(GameplayOption.ENABLE_LOWERED_STARTING_HEALTH)) {
            if (modifier != null) {
                maxHealthInstance.func_188479_b(HealthHelper.STARTING_HEALTH_MODIFIER_ID);
            }
            return;
        }
        int startingHealth = this.getStartingHearts(difficulty);
        double difficultyHealthDecrement = -20 + startingHealth * 2;
        double overallHealthDecrement = difficultyHealthDecrement + (lifebloodHearts = (double)(HealthHelper.getLifebloodHearts(player) * 2));
        if (overallHealthDecrement > (extraHealth = (double)(this.getMaxHearts() * 2 - 20))) {
            difficultyHealthDecrement -= overallHealthDecrement - extraHealth;
        }
        if (modifier == null || modifier.func_111164_d() != difficultyHealthDecrement) {
            HashMultimap multimap = HashMultimap.create();
            modifier = new AttributeModifier(HealthHelper.STARTING_HEALTH_MODIFIER_ID, "Starting Health Modifier", difficultyHealthDecrement, 0);
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)modifier);
            player.func_110140_aT().func_111147_b((Multimap)multimap);
            if (player.func_110143_aJ() > player.func_110138_aP()) {
                player.func_70606_j(player.func_110138_aP());
            }
        }
    }

    @Override
    public int getMaxHearts() {
        return ModConfig.gameplay.maxHearts;
    }

    @Override
    public int getStartingHearts(EnumDifficulty difficulty) {
        switch (difficulty) {
            case EASY: {
                return ModConfig.gameplay.easyStartingHearts;
            }
            case NORMAL: {
                return ModConfig.gameplay.normalStartingHearts;
            }
            case HARD: {
                return ModConfig.gameplay.hardStartingHearts;
            }
        }
        return 10;
    }
}

