/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.handler.season;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import toughasnails.api.config.SeasonsOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.season.ISeasonData;
import toughasnails.api.season.Season;
import toughasnails.api.season.SeasonHelper;
import toughasnails.handler.PacketHandler;
import toughasnails.network.message.MessageSyncSeasonCycle;
import toughasnails.season.SeasonSavedData;
import toughasnails.season.SeasonTime;

public class SeasonHandler
implements SeasonHelper.ISeasonDataProvider {
    private Season.SubSeason lastSeason = null;
    public static int clientSeasonCycleTicks = 0;

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (event.phase == TickEvent.Phase.END && !world.field_72995_K && world.field_73011_w.getDimension() == 0 && SyncedConfig.getBooleanValue(SeasonsOption.ENABLE_SEASONS)) {
            SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(world);
            if (savedData.seasonCycleTicks++ > SeasonTime.ZERO.getCycleDuration()) {
                savedData.seasonCycleTicks = 0;
            }
            if (savedData.seasonCycleTicks % 20 == 0) {
                SeasonHandler.sendSeasonUpdate(world);
            }
            savedData.func_76185_a();
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        SeasonHandler.sendSeasonUpdate(world);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        int dimension = Minecraft.func_71410_x().field_71439_g.field_71093_bK;
        if (event.phase == TickEvent.Phase.END && dimension == 0 && SyncedConfig.getBooleanValue(SeasonsOption.ENABLE_SEASONS)) {
            SeasonTime calendar;
            if (clientSeasonCycleTicks++ > SeasonTime.ZERO.getCycleDuration()) {
                clientSeasonCycleTicks = 0;
            }
            if ((calendar = new SeasonTime(clientSeasonCycleTicks)).getSubSeason() != this.lastSeason) {
                Minecraft.func_71410_x().field_71438_f.func_72712_a();
                this.lastSeason = calendar.getSubSeason();
            }
        }
    }

    public static void sendSeasonUpdate(World world) {
        if (!world.field_72995_K && SyncedConfig.getBooleanValue(SeasonsOption.ENABLE_SEASONS)) {
            SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(world);
            PacketHandler.instance.sendToAll((IMessage)new MessageSyncSeasonCycle(savedData.seasonCycleTicks));
        }
    }

    public static SeasonSavedData getSeasonSavedData(World world) {
        MapStorage mapStorage = world.getPerWorldStorage();
        SeasonSavedData savedData = (SeasonSavedData)mapStorage.func_75742_a(SeasonSavedData.class, "seasons");
        if (savedData == null) {
            savedData = new SeasonSavedData("seasons");
            mapStorage.func_75745_a("seasons", (WorldSavedData)savedData);
            savedData.func_76185_a();
        }
        return savedData;
    }

    @Override
    public ISeasonData getServerSeasonData(World world) {
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(world);
        return new SeasonTime(savedData.seasonCycleTicks);
    }

    @Override
    public ISeasonData getClientSeasonData() {
        return new SeasonTime(clientSeasonCycleTicks);
    }
}

