/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.handler.season;

import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import toughasnails.api.config.SeasonsOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.season.Season;
import toughasnails.api.season.SeasonHelper;

public class StopSpawnHandler {
    @SubscribeEvent
    public void onCheckEntitySpawn(LivingSpawnEvent.CheckSpawn event) {
        Season season = SeasonHelper.getSeasonData(event.getWorld()).getSubSeason().getSeason();
        if (season == Season.WINTER && event.getEntity() instanceof EntityAnimal && SyncedConfig.getBooleanValue(SeasonsOption.ENABLE_SEASONS)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onChunkPopulate(PopulateChunkEvent.Populate event) {
        World world = event.getWorld();
        Season season = SeasonHelper.getSeasonData(world).getSubSeason().getSeason();
        if (event.getType() == PopulateChunkEvent.Populate.EventType.ANIMALS && season == Season.WINTER && SyncedConfig.getBooleanValue(SeasonsOption.ENABLE_SEASONS)) {
            event.setResult(Event.Result.DENY);
        }
    }
}

