/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.handler.temperature;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import toughasnails.api.TANCapabilities;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.config.TemperatureOption;
import toughasnails.api.temperature.Temperature;
import toughasnails.api.temperature.TemperatureScale;
import toughasnails.temperature.TemperatureHandler;
import toughasnails.util.RenderUtils;

@SideOnly(value=Side.CLIENT)
public class TemperatureOverlayHandler {
    public static final ResourceLocation OVERLAY = new ResourceLocation("toughasnails:textures/gui/overlay.png");
    public static final ResourceLocation ICE_VIGNETTE = new ResourceLocation("toughasnails:textures/gui/ice_vignette.png");
    public static final ResourceLocation FIRE_VIGNETTE = new ResourceLocation("toughasnails:textures/gui/fire_vignette.png");
    private final Random random = new Random();
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private int updateCounter;
    private FlashType flashType = FlashType.INCREASE;
    private int flashCounter = -1;
    private int prevTemperatureLevel = -1;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !this.minecraft.func_147113_T()) {
            ++this.updateCounter;
        }
    }

    @SubscribeEvent
    public void onPostRenderOverlay(RenderGameOverlayEvent.Post event) {
        ScaledResolution resolution = event.getResolution();
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        TemperatureHandler temperatureStats = (TemperatureHandler)player.getCapability(TANCapabilities.TEMPERATURE, null);
        Temperature temperature = temperatureStats.getTemperature();
        this.random.setSeed(this.updateCounter * 312871);
        if (event.getType() == RenderGameOverlayEvent.ElementType.PORTAL && SyncedConfig.getBooleanValue(TemperatureOption.ENABLE_TEMPERATURE)) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.drawTemperatureVignettes(width, height, temperature);
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE && SyncedConfig.getBooleanValue(TemperatureOption.ENABLE_TEMPERATURE)) {
            this.minecraft.func_110434_K().func_110577_a(OVERLAY);
            if (this.minecraft.field_71442_b.func_78763_f()) {
                this.drawTemperature(width, height, temperature);
            }
        }
    }

    private void drawTemperature(int width, int height, Temperature temperature) {
        int left = width / 2 - 8;
        int top = height - 52;
        TemperatureScale.TemperatureRange temperatureRange = temperature.getRange();
        if (temperatureRange == TemperatureScale.TemperatureRange.ICY || temperatureRange == TemperatureScale.TemperatureRange.HOT) {
            float shakeDelta;
            float f = shakeDelta = temperatureRange == TemperatureScale.TemperatureRange.ICY ? temperature.getRangeDelta(true) : temperature.getRangeDelta(false);
            if (this.updateCounter % 1 == 0) {
                top += (int)((double)(this.random.nextInt(3) - 1) * Math.min((double)(shakeDelta * 3.0f), 1.0));
                left += (int)((double)(this.random.nextInt(3) - 1) * Math.min((double)(shakeDelta * 1.5f), 1.0));
            }
        }
        int temperatureLevel = temperature.getRawValue();
        if (this.prevTemperatureLevel == -1) {
            this.prevTemperatureLevel = temperatureLevel;
        }
        if (temperatureLevel > this.prevTemperatureLevel) {
            this.flashCounter = this.updateCounter + 16;
            this.flashType = FlashType.INCREASE;
        } else if (temperatureLevel < this.prevTemperatureLevel) {
            this.flashCounter = this.updateCounter + 16;
            this.flashType = FlashType.DECREASE;
        }
        this.prevTemperatureLevel = temperatureLevel;
        TemperatureIcon temperatureIcon = TemperatureOverlayHandler.getTemperatureIcon(temperatureLevel);
        int updateDelta = this.flashCounter - this.updateCounter;
        RenderUtils.drawTexturedModalRect(left, top, 16 * temperatureIcon.backgroundIndex, 0, 16, 16);
        RenderUtils.drawTexturedModalRect(left, top, 16 * temperatureIcon.foregroundIndex, 0, 16, 16);
        if (temperatureIcon == TemperatureIcon.BALL) {
            this.renderColouredBall(left, top, temperature, 0);
        }
        if ((long)this.flashCounter > (long)this.updateCounter) {
            if (updateDelta > 6 && (long)updateDelta / 3L % 2L == 1L) {
                RenderUtils.drawTexturedModalRect(left, top, 16 * (temperatureIcon.backgroundIndex + this.flashType.backgroundShift), 0, 16, 16);
                RenderUtils.drawTexturedModalRect(left, top, 16 * (temperatureIcon.foregroundIndex + this.flashType.foregroundShift), 0, 16, 16);
                if (temperatureIcon == TemperatureIcon.BALL) {
                    this.renderColouredBall(left, top, temperature, 2);
                }
            }
            GlStateManager.func_179094_E();
            if (this.flashType == FlashType.INCREASE) {
                GL11.glTranslatef((float)((float)left + 16.0f), (float)((float)top + 16.0f), (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            } else {
                GL11.glTranslatef((float)left, (float)top, (float)0.0f);
            }
            RenderUtils.drawTexturedModalRect(0, 0, 16 * (16 - updateDelta), 240, 16, 16);
            GlStateManager.func_179121_F();
        }
    }

    private void renderColouredBall(int x, int y, Temperature temperature, int textureShift) {
        float changeDelta;
        TemperatureScale.TemperatureRange temperatureRange = temperature.getRange();
        float f = changeDelta = temperatureRange == TemperatureScale.TemperatureRange.COOL ? temperature.getRangeDelta(true) : temperature.getRangeDelta(false);
        if (temperatureRange != TemperatureScale.TemperatureRange.MILD) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)changeDelta);
            RenderUtils.drawTexturedModalRect(x, y, 16 * ((temperatureRange == TemperatureScale.TemperatureRange.COOL ? 8 : 9) + textureShift), 16, 16, 16);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    private void drawTemperatureVignettes(int width, int height, Temperature temperature) {
        TemperatureScale.TemperatureRange temperatureRange = temperature.getRange();
        float opacityDelta = temperature.getRangeDelta(false);
        ResourceLocation vignetteLocation = null;
        if (temperatureRange == TemperatureScale.TemperatureRange.ICY) {
            opacityDelta = 1.0f - temperature.getRangeDelta(true);
            vignetteLocation = ICE_VIGNETTE;
        } else if (temperatureRange == TemperatureScale.TemperatureRange.HOT) {
            vignetteLocation = FIRE_VIGNETTE;
        }
        if (vignetteLocation != null) {
            this.minecraft.func_110434_K().func_110577_a(vignetteLocation);
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)opacityDelta);
            GlStateManager.func_179118_c();
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer renderer = tessellator.func_178180_c();
            renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            renderer.func_181662_b(0.0, (double)height, -90.0).func_187315_a(0.0, 1.0).func_181675_d();
            renderer.func_181662_b((double)width, (double)height, -90.0).func_187315_a(1.0, 1.0).func_181675_d();
            renderer.func_181662_b((double)width, 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
            renderer.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static TemperatureIcon getTemperatureIcon(int scalePos) {
        if (scalePos < 0 || scalePos > TemperatureScale.getScaleTotal()) {
            return null;
        }
        TemperatureIcon temperatureIcon = null;
        for (int index = 0; index < TemperatureIcon.values().length; ++index) {
            temperatureIcon = TemperatureIcon.values()[index];
            if (TemperatureScale.isScalePosInRange(scalePos, temperatureIcon.startRange, temperatureIcon.endRange)) break;
        }
        return temperatureIcon;
    }

    private static enum FlashType {
        INCREASE(3, 3),
        DECREASE(3, 3);

        public final int backgroundShift;
        public final int foregroundShift;

        private FlashType(int backgroundShift, int foregroundShift) {
            this.backgroundShift = backgroundShift;
            this.foregroundShift = foregroundShift;
        }
    }

    private static enum TemperatureIcon {
        SNOWFLAKE(0, 9, TemperatureScale.TemperatureRange.ICY),
        BALL(1, 10, TemperatureScale.TemperatureRange.COOL, TemperatureScale.TemperatureRange.WARM),
        FIRE(2, 11, TemperatureScale.TemperatureRange.HOT);

        public final int backgroundIndex;
        public final int foregroundIndex;
        public final TemperatureScale.TemperatureRange startRange;
        public final TemperatureScale.TemperatureRange endRange;

        private TemperatureIcon(int backgroundIndex, int foregroundIndex, TemperatureScale.TemperatureRange startRange, TemperatureScale.TemperatureRange endRange) {
            this.backgroundIndex = backgroundIndex;
            this.foregroundIndex = foregroundIndex;
            this.startRange = startRange;
            this.endRange = endRange;
        }

        private TemperatureIcon(int backgroundIndex, int foregroundIndex, TemperatureScale.TemperatureRange range) {
            this(backgroundIndex, foregroundIndex, range, range);
        }
    }
}

