/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toughasnails.api.TANCapabilities;
import toughasnails.api.TANPotions;
import toughasnails.api.config.GameplayOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.thirst.WaterType;
import toughasnails.thirst.ThirstHandler;

public class ItemCanteen
extends Item {
    public ItemCanteen() {
        this.func_185043_a(new ResourceLocation("filled"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World world, EntityLivingBase entity) {
                WaterType waterType = ItemCanteen.this.getWaterType(stack);
                if (waterType == null) {
                    return 0.0f;
                }
                return 1.0f;
            }
        });
        this.field_77777_bU = 1;
        this.func_77656_e(3);
        this.setNoRepair();
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        WaterType waterType = this.getWaterType(stack);
        if (entity instanceof EntityPlayer && waterType != null) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.field_71075_bZ.field_75098_d) {
                int damage = (stack.func_77952_i() >> 2) + 1;
                int typeIndex = waterType.ordinal() + 1;
                if (damage == this.func_77612_l()) {
                    damage = 0;
                    typeIndex = 0;
                }
                this.setDamage(stack, typeIndex | damage << 2);
            }
            ThirstHandler thirstStats = (ThirstHandler)player.getCapability(TANCapabilities.THIRST, null);
            thirstStats.addStats(waterType.getThirst(), waterType.getHydration());
            if (!world.field_72995_K && world.field_73012_v.nextFloat() < waterType.getPoisonChance() && SyncedConfig.getBooleanValue(GameplayOption.ENABLE_THIRST)) {
                player.func_70690_d(new PotionEffect(TANPotions.thirst, 600));
            }
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ThirstHandler thirstStats = (ThirstHandler)player.getCapability(TANCapabilities.THIRST, null);
        WaterType waterType = this.getWaterType(stack);
        if (!this.attemptCanteenFill(player, stack) && waterType != null && this.getTimesUsed(stack) < 3 && thirstStats.isThirsty()) {
            player.func_184598_c(hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)(stack.func_77952_i() >> 2) / (double)stack.func_77958_k();
    }

    private boolean attemptCanteenFill(EntityPlayer player, ItemStack stack) {
        World world = player.field_70170_p;
        RayTraceResult movingObjectPos = this.func_77621_a(world, player, true);
        if (movingObjectPos != null && movingObjectPos.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = movingObjectPos.func_178782_a();
            IBlockState state = world.func_180495_p(pos);
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)state.func_177230_c());
            if (fluid != null && fluid == FluidRegistry.WATER) {
                stack.func_77964_b(1);
                return true;
            }
            if (state.func_177230_c() instanceof BlockCauldron) {
                BlockCauldron cauldron = (BlockCauldron)state.func_177230_c();
                int level = (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a);
                if (level > 0 && !world.field_72995_K) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_71029_a(StatList.field_188078_L);
                        stack.func_77964_b(1);
                        return true;
                    }
                    cauldron.func_176590_a(world, pos, state, level - 1);
                }
            }
        }
        return false;
    }

    private WaterType getWaterType(ItemStack stack) {
        int type = stack.func_77960_j() & 3;
        return type > 0 ? WaterType.values()[type - 1] : null;
    }

    private int getTimesUsed(ItemStack stack) {
        return stack.func_77952_i() >> 2;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public String func_77667_c(ItemStack stack) {
        WaterType type = this.getWaterType(stack);
        if (type != null) {
            return "item." + type.toString().toLowerCase() + "_water_canteen";
        }
        return "item.empty_canteen";
    }
}

